/*
 * helicopter_R2016b.c
 *
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * Code generation for model "helicopter_R2016b".
 *
 * Model version              : 11.8
 * Simulink Coder version : 9.4 (R2020b) 29-Jul-2020
 * C source code generated on : Thu Mar  6 12:34:39 2025
 *
 * Target selection: quarc_win64.tlc
 * Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: 32-bit Generic
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "helicopter_R2016b.h"
#include "helicopter_R2016b_private.h"
#include "helicopter_R2016b_dt.h"

/* Block signals (default storage) */
B_helicopter_R2016b_T helicopter_R2016b_B;

/* Continuous states */
X_helicopter_R2016b_T helicopter_R2016b_X;

/* Block states (default storage) */
DW_helicopter_R2016b_T helicopter_R2016b_DW;

/* Real-time model */
static RT_MODEL_helicopter_R2016b_T helicopter_R2016b_M_;
RT_MODEL_helicopter_R2016b_T *const helicopter_R2016b_M = &helicopter_R2016b_M_;

/*
 * This function updates continuous states using the ODE1 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE1_IntgData *id = (ODE1_IntgData *)rtsiGetSolverData(si);
  real_T *f0 = id->f[0];
  int_T i;
  int_T nXc = 4;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);
  rtsiSetdX(si, f0);
  helicopter_R2016b_derivatives();
  rtsiSetT(si, tnew);
  for (i = 0; i < nXc; ++i) {
    x[i] += h * f0[i];
  }

  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

/* Model output function */
void helicopter_R2016b_output(void)
{
  /* local block i/o variables */
  real_T rtb_HILReadEncoderTimebase_o1;
  real_T rtb_HILReadEncoderTimebase_o2;
  real_T rtb_Round;
  real_T lastTime;
  real_T rtb_Backgain;
  real_T rtb_Clock;
  real_T rtb_Derivative;
  real_T *lastU;
  int8_T rtAction;
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    /* set solver stop time */
    if (!(helicopter_R2016b_M->Timing.clockTick0+1)) {
      rtsiSetSolverStopTime(&helicopter_R2016b_M->solverInfo,
                            ((helicopter_R2016b_M->Timing.clockTickH0 + 1) *
        helicopter_R2016b_M->Timing.stepSize0 * 4294967296.0));
    } else {
      rtsiSetSolverStopTime(&helicopter_R2016b_M->solverInfo,
                            ((helicopter_R2016b_M->Timing.clockTick0 + 1) *
        helicopter_R2016b_M->Timing.stepSize0 +
        helicopter_R2016b_M->Timing.clockTickH0 *
        helicopter_R2016b_M->Timing.stepSize0 * 4294967296.0));
    }
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(helicopter_R2016b_M)) {
    helicopter_R2016b_M->Timing.t[0] = rtsiGetT(&helicopter_R2016b_M->solverInfo);
  }

  /* Reset subsysRan breadcrumbs */
  srClearBC(helicopter_R2016b_DW.IfActionSubsystem_SubsysRanBC);
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    /* S-Function (hil_read_encoder_timebase_block): '<S5>/HIL Read Encoder Timebase' */

    /* S-Function Block: helicopter_R2016b/Helicopter_interface/HIL Read Encoder Timebase (hil_read_encoder_timebase_block) */
    {
      t_error result;
      result = hil_task_read_encoder
        (helicopter_R2016b_DW.HILReadEncoderTimebase_Task, 1,
         &helicopter_R2016b_DW.HILReadEncoderTimebase_Buffer[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
      } else {
        rtb_HILReadEncoderTimebase_o1 =
          helicopter_R2016b_DW.HILReadEncoderTimebase_Buffer[0];
        rtb_HILReadEncoderTimebase_o2 =
          helicopter_R2016b_DW.HILReadEncoderTimebase_Buffer[1];
        rtb_Round = helicopter_R2016b_DW.HILReadEncoderTimebase_Buffer[2];
      }
    }

    /* Gain: '<S5>/Travel: Count to rad' incorporates:
     *  Gain: '<S5>/Travel_gain'
     */
    helicopter_R2016b_B.TravelCounttorad = helicopter_R2016b_P.travel_gain *
      rtb_HILReadEncoderTimebase_o1 * helicopter_R2016b_P.TravelCounttorad_Gain;

    /* Gain: '<S13>/Gain' */
    helicopter_R2016b_B.Gain = helicopter_R2016b_P.Gain_Gain *
      helicopter_R2016b_B.TravelCounttorad;

    /* Gain: '<S5>/Pitch: Count to rad' */
    helicopter_R2016b_B.PitchCounttorad =
      helicopter_R2016b_P.PitchCounttorad_Gain * rtb_HILReadEncoderTimebase_o2;

    /* Gain: '<S10>/Gain' */
    helicopter_R2016b_B.Gain_i = helicopter_R2016b_P.Gain_Gain_a *
      helicopter_R2016b_B.PitchCounttorad;
  }

  /* Gain: '<S14>/Gain' incorporates:
   *  TransferFcn: '<S5>/Travel: Transfer Fcn'
   */
  helicopter_R2016b_B.Gain_d = (helicopter_R2016b_P.TravelTransferFcn_C *
    helicopter_R2016b_X.TravelTransferFcn_CSTATE +
    helicopter_R2016b_P.TravelTransferFcn_D *
    helicopter_R2016b_B.TravelCounttorad) * helicopter_R2016b_P.Gain_Gain_l;

  /* Gain: '<S11>/Gain' incorporates:
   *  TransferFcn: '<S5>/Pitch: Transfer Fcn'
   */
  helicopter_R2016b_B.Gain_b = (helicopter_R2016b_P.PitchTransferFcn_C *
    helicopter_R2016b_X.PitchTransferFcn_CSTATE +
    helicopter_R2016b_P.PitchTransferFcn_D * helicopter_R2016b_B.PitchCounttorad)
    * helicopter_R2016b_P.Gain_Gain_ae;
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    /* Gain: '<S5>/Elevation: Count to rad' incorporates:
     *  Gain: '<S5>/Elevation_gain'
     */
    helicopter_R2016b_B.ElevationCounttorad = helicopter_R2016b_P.elevation_gain
      * rtb_Round * helicopter_R2016b_P.ElevationCounttorad_Gain;

    /* Gain: '<S8>/Gain' */
    helicopter_R2016b_B.Gain_e = helicopter_R2016b_P.Gain_Gain_lv *
      helicopter_R2016b_B.ElevationCounttorad;

    /* Sum: '<Root>/Sum' incorporates:
     *  Constant: '<Root>/elavation_offset [deg]'
     */
    helicopter_R2016b_B.Sum = helicopter_R2016b_B.Gain_e +
      helicopter_R2016b_P.elavation_offsetdeg_Value;
  }

  /* Gain: '<S9>/Gain' incorporates:
   *  TransferFcn: '<S5>/Elevation: Transfer Fcn'
   */
  helicopter_R2016b_B.Gain_dg = (helicopter_R2016b_P.ElevationTransferFcn_C *
    helicopter_R2016b_X.ElevationTransferFcn_CSTATE +
    helicopter_R2016b_P.ElevationTransferFcn_D *
    helicopter_R2016b_B.ElevationCounttorad) * helicopter_R2016b_P.Gain_Gain_n;

  /* Gain: '<S2>/Gain1' */
  helicopter_R2016b_B.Gain1[0] = helicopter_R2016b_P.Gain1_Gain *
    helicopter_R2016b_B.Gain;
  helicopter_R2016b_B.Gain1[1] = helicopter_R2016b_P.Gain1_Gain *
    helicopter_R2016b_B.Gain_d;
  helicopter_R2016b_B.Gain1[2] = helicopter_R2016b_P.Gain1_Gain *
    helicopter_R2016b_B.Gain_i;
  helicopter_R2016b_B.Gain1[3] = helicopter_R2016b_P.Gain1_Gain *
    helicopter_R2016b_B.Gain_b;
  helicopter_R2016b_B.Gain1[4] = helicopter_R2016b_P.Gain1_Gain *
    helicopter_R2016b_B.Sum;
  helicopter_R2016b_B.Gain1[5] = helicopter_R2016b_P.Gain1_Gain *
    helicopter_R2016b_B.Gain_dg;
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
  }

  /* FromWorkspace: '<Root>/From Workspace' */
  {
    real_T *pDataValues = (real_T *)
      helicopter_R2016b_DW.FromWorkspace_PWORK.DataPtr;
    real_T *pTimeValues = (real_T *)
      helicopter_R2016b_DW.FromWorkspace_PWORK.TimePtr;
    int_T currTimeIndex = helicopter_R2016b_DW.FromWorkspace_IWORK.PrevIndex;
    real_T t = helicopter_R2016b_M->Timing.t[0];

    /* Get index */
    if (t <= pTimeValues[0]) {
      currTimeIndex = 0;
    } else if (t >= pTimeValues[140]) {
      currTimeIndex = 139;
    } else {
      if (t < pTimeValues[currTimeIndex]) {
        while (t < pTimeValues[currTimeIndex]) {
          currTimeIndex--;
        }
      } else {
        while (t >= pTimeValues[currTimeIndex + 1]) {
          currTimeIndex++;
        }
      }
    }

    helicopter_R2016b_DW.FromWorkspace_IWORK.PrevIndex = currTimeIndex;

    /* Post output */
    {
      real_T t1 = pTimeValues[currTimeIndex];
      real_T t2 = pTimeValues[currTimeIndex + 1];
      if (t1 == t2) {
        if (t < t1) {
          helicopter_R2016b_B.FromWorkspace = pDataValues[currTimeIndex];
        } else {
          helicopter_R2016b_B.FromWorkspace = pDataValues[currTimeIndex + 1];
        }
      } else {
        real_T f1 = (t2 - t) / (t2 - t1);
        real_T f2 = 1.0 - f1;
        real_T d1;
        real_T d2;
        int_T TimeIndex= currTimeIndex;
        d1 = pDataValues[TimeIndex];
        d2 = pDataValues[TimeIndex + 1];
        helicopter_R2016b_B.FromWorkspace = (real_T) rtInterpolate(d1, d2, f1,
          f2);
        pDataValues += 141;
      }
    }
  }

  /* FromWorkspace: '<Root>/From Workspace2' */
  {
    real_T *pDataValues = (real_T *)
      helicopter_R2016b_DW.FromWorkspace2_PWORK.DataPtr;
    real_T *pTimeValues = (real_T *)
      helicopter_R2016b_DW.FromWorkspace2_PWORK.TimePtr;
    int_T currTimeIndex = helicopter_R2016b_DW.FromWorkspace2_IWORK.PrevIndex;
    real_T t = helicopter_R2016b_M->Timing.t[0];

    /* Get index */
    if (t <= pTimeValues[0]) {
      currTimeIndex = 0;
    } else if (t >= pTimeValues[140]) {
      currTimeIndex = 139;
    } else {
      if (t < pTimeValues[currTimeIndex]) {
        while (t < pTimeValues[currTimeIndex]) {
          currTimeIndex--;
        }
      } else {
        while (t >= pTimeValues[currTimeIndex + 1]) {
          currTimeIndex++;
        }
      }
    }

    helicopter_R2016b_DW.FromWorkspace2_IWORK.PrevIndex = currTimeIndex;

    /* Post output */
    {
      real_T t1 = pTimeValues[currTimeIndex];
      real_T t2 = pTimeValues[currTimeIndex + 1];
      if (t1 == t2) {
        if (t < t1) {
          {
            int_T elIdx;
            for (elIdx = 0; elIdx < 4; ++elIdx) {
              (&helicopter_R2016b_B.FromWorkspace2[0])[elIdx] =
                pDataValues[currTimeIndex];
              pDataValues += 141;
            }
          }
        } else {
          {
            int_T elIdx;
            for (elIdx = 0; elIdx < 4; ++elIdx) {
              (&helicopter_R2016b_B.FromWorkspace2[0])[elIdx] =
                pDataValues[currTimeIndex + 1];
              pDataValues += 141;
            }
          }
        }
      } else {
        real_T f1 = (t2 - t) / (t2 - t1);
        real_T f2 = 1.0 - f1;
        real_T d1;
        real_T d2;
        int_T TimeIndex= currTimeIndex;

        {
          int_T elIdx;
          for (elIdx = 0; elIdx < 4; ++elIdx) {
            d1 = pDataValues[TimeIndex];
            d2 = pDataValues[TimeIndex + 1];
            (&helicopter_R2016b_B.FromWorkspace2[0])[elIdx] = (real_T)
              rtInterpolate(d1, d2, f1, f2);
            pDataValues += 141;
          }
        }
      }
    }
  }

  /* Switch: '<Root>/Switch' incorporates:
   *  Constant: '<Root>/Constant'
   *  Constant: '<Root>/Constant1'
   *  Constant: '<Root>/Constant2'
   *  DotProduct: '<Root>/Dot Product'
   *  Sum: '<Root>/Sum3'
   */
  if (helicopter_R2016b_P.Constant_Value > helicopter_R2016b_P.Switch_Threshold)
  {
    rtb_Clock = (((helicopter_R2016b_B.Gain1[0] -
                   helicopter_R2016b_B.FromWorkspace2[0]) *
                  helicopter_R2016b_P.K[0] + (helicopter_R2016b_B.Gain1[1] -
      helicopter_R2016b_B.FromWorkspace2[1]) * helicopter_R2016b_P.K[1]) +
                 (helicopter_R2016b_B.Gain1[2] -
                  helicopter_R2016b_B.FromWorkspace2[2]) *
                 helicopter_R2016b_P.K[2]) + (helicopter_R2016b_B.Gain1[3] -
      helicopter_R2016b_B.FromWorkspace2[3]) * helicopter_R2016b_P.K[3];
  } else {
    rtb_Clock = helicopter_R2016b_P.Constant1_Value;
  }

  /* End of Switch: '<Root>/Switch' */

  /* Sum: '<Root>/Sum4' */
  helicopter_R2016b_B.Sum4 = helicopter_R2016b_B.FromWorkspace - rtb_Clock;
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
  }

  /* Sum: '<Root>/Sum1' incorporates:
   *  Constant: '<Root>/Vd_bias'
   *  Gain: '<S6>/K_pd'
   *  Gain: '<S6>/K_pp'
   *  Sum: '<S6>/Sum2'
   *  Sum: '<S6>/Sum3'
   */
  rtb_Clock = ((helicopter_R2016b_B.Sum4 - helicopter_R2016b_B.Gain1[2]) *
               helicopter_R2016b_P.K_pp - helicopter_R2016b_P.K_pd *
               helicopter_R2016b_B.Gain1[3]) + helicopter_R2016b_P.Vd_ff;

  /* Integrator: '<S4>/Integrator' */
  /* Limited  Integrator  */
  if (helicopter_R2016b_X.Integrator_CSTATE >=
      helicopter_R2016b_P.Integrator_UpperSat) {
    helicopter_R2016b_X.Integrator_CSTATE =
      helicopter_R2016b_P.Integrator_UpperSat;
  } else {
    if (helicopter_R2016b_X.Integrator_CSTATE <=
        helicopter_R2016b_P.Integrator_LowerSat) {
      helicopter_R2016b_X.Integrator_CSTATE =
        helicopter_R2016b_P.Integrator_LowerSat;
    }
  }

  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    /* Rounding: '<Root>/Round' incorporates:
     *  Constant: '<Root>/elevation_ref'
     */
    rtb_Round = rt_roundd_snf(helicopter_R2016b_P.elevation_ref_Value);

    /* Gain: '<S3>/Gain1' */
    helicopter_R2016b_B.Gain1_m = helicopter_R2016b_P.Gain1_Gain_d * rtb_Round;
  }

  /* Sum: '<S4>/Sum' */
  rtb_Derivative = helicopter_R2016b_B.Gain1_m - helicopter_R2016b_B.Gain1[4];

  /* Sum: '<Root>/Sum2' incorporates:
   *  Constant: '<Root>/Vs_bias'
   *  Gain: '<S4>/K_ed'
   *  Gain: '<S4>/K_ep'
   *  Integrator: '<S4>/Integrator'
   *  Sum: '<S4>/Sum1'
   */
  rtb_Backgain = ((helicopter_R2016b_P.K_ep * rtb_Derivative +
                   helicopter_R2016b_X.Integrator_CSTATE) -
                  helicopter_R2016b_P.K_ed * helicopter_R2016b_B.Gain1[5]) +
    helicopter_R2016b_P.Vs_ff;

  /* If: '<S4>/If' incorporates:
   *  Clock: '<S4>/Clock'
   *  Gain: '<S4>/K_ei'
   *  Inport: '<S7>/In1'
   */
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    rtAction = (int8_T)!(helicopter_R2016b_M->Timing.t[0] >= 2.0);
    helicopter_R2016b_DW.If_ActiveSubsystem = rtAction;
  } else {
    rtAction = helicopter_R2016b_DW.If_ActiveSubsystem;
  }

  if (rtAction == 0) {
    /* Outputs for IfAction SubSystem: '<S4>/If Action Subsystem' incorporates:
     *  ActionPort: '<S7>/Action Port'
     */
    helicopter_R2016b_B.In1 = helicopter_R2016b_P.K_ei * rtb_Derivative;
    if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
      srUpdateBC(helicopter_R2016b_DW.IfActionSubsystem_SubsysRanBC);
    }

    /* End of Outputs for SubSystem: '<S4>/If Action Subsystem' */
  }

  /* End of If: '<S4>/If' */
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
  }

  /* Derivative: '<S5>/Derivative' */
  rtb_Derivative = helicopter_R2016b_M->Timing.t[0];
  if ((helicopter_R2016b_DW.TimeStampA >= rtb_Derivative) &&
      (helicopter_R2016b_DW.TimeStampB >= rtb_Derivative)) {
    rtb_Derivative = 0.0;
  } else {
    lastTime = helicopter_R2016b_DW.TimeStampA;
    lastU = &helicopter_R2016b_DW.LastUAtTimeA;
    if (helicopter_R2016b_DW.TimeStampA < helicopter_R2016b_DW.TimeStampB) {
      if (helicopter_R2016b_DW.TimeStampB < rtb_Derivative) {
        lastTime = helicopter_R2016b_DW.TimeStampB;
        lastU = &helicopter_R2016b_DW.LastUAtTimeB;
      }
    } else {
      if (helicopter_R2016b_DW.TimeStampA >= rtb_Derivative) {
        lastTime = helicopter_R2016b_DW.TimeStampB;
        lastU = &helicopter_R2016b_DW.LastUAtTimeB;
      }
    }

    rtb_Derivative = (helicopter_R2016b_B.PitchCounttorad - *lastU) /
      (rtb_Derivative - lastTime);
  }

  /* End of Derivative: '<S5>/Derivative' */

  /* Gain: '<S12>/Gain' */
  helicopter_R2016b_B.Gain_l = helicopter_R2016b_P.Gain_Gain_a1 * rtb_Derivative;
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
  }

  /* Gain: '<S1>/Back gain' incorporates:
   *  Sum: '<S1>/Subtract'
   */
  rtb_Derivative = (rtb_Backgain - rtb_Clock) *
    helicopter_R2016b_P.Backgain_Gain;

  /* Saturate: '<S5>/Back motor: Saturation' */
  if (rtb_Derivative > helicopter_R2016b_P.BackmotorSaturation_UpperSat) {
    /* Saturate: '<S5>/Back motor: Saturation' */
    helicopter_R2016b_B.BackmotorSaturation =
      helicopter_R2016b_P.BackmotorSaturation_UpperSat;
  } else if (rtb_Derivative < helicopter_R2016b_P.BackmotorSaturation_LowerSat)
  {
    /* Saturate: '<S5>/Back motor: Saturation' */
    helicopter_R2016b_B.BackmotorSaturation =
      helicopter_R2016b_P.BackmotorSaturation_LowerSat;
  } else {
    /* Saturate: '<S5>/Back motor: Saturation' */
    helicopter_R2016b_B.BackmotorSaturation = rtb_Derivative;
  }

  /* End of Saturate: '<S5>/Back motor: Saturation' */
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
  }

  /* Gain: '<S1>/Front gain' incorporates:
   *  Sum: '<S1>/Add'
   */
  rtb_Derivative = (rtb_Clock + rtb_Backgain) *
    helicopter_R2016b_P.Frontgain_Gain;

  /* Saturate: '<S5>/Front motor: Saturation' */
  if (rtb_Derivative > helicopter_R2016b_P.FrontmotorSaturation_UpperSat) {
    /* Saturate: '<S5>/Front motor: Saturation' */
    helicopter_R2016b_B.FrontmotorSaturation =
      helicopter_R2016b_P.FrontmotorSaturation_UpperSat;
  } else if (rtb_Derivative < helicopter_R2016b_P.FrontmotorSaturation_LowerSat)
  {
    /* Saturate: '<S5>/Front motor: Saturation' */
    helicopter_R2016b_B.FrontmotorSaturation =
      helicopter_R2016b_P.FrontmotorSaturation_LowerSat;
  } else {
    /* Saturate: '<S5>/Front motor: Saturation' */
    helicopter_R2016b_B.FrontmotorSaturation = rtb_Derivative;
  }

  /* End of Saturate: '<S5>/Front motor: Saturation' */
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    /* S-Function (hil_write_analog_block): '<S5>/HIL Write Analog' */

    /* S-Function Block: helicopter_R2016b/Helicopter_interface/HIL Write Analog (hil_write_analog_block) */
    {
      t_error result;
      helicopter_R2016b_DW.HILWriteAnalog_Buffer[0] =
        helicopter_R2016b_B.FrontmotorSaturation;
      helicopter_R2016b_DW.HILWriteAnalog_Buffer[1] =
        helicopter_R2016b_B.BackmotorSaturation;
      result = hil_write_analog(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILWriteAnalog_channels, 2,
        &helicopter_R2016b_DW.HILWriteAnalog_Buffer[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
      }
    }
  }
}

/* Model update function */
void helicopter_R2016b_update(void)
{
  real_T *lastU;

  /* Update for Derivative: '<S5>/Derivative' */
  if (helicopter_R2016b_DW.TimeStampA == (rtInf)) {
    helicopter_R2016b_DW.TimeStampA = helicopter_R2016b_M->Timing.t[0];
    lastU = &helicopter_R2016b_DW.LastUAtTimeA;
  } else if (helicopter_R2016b_DW.TimeStampB == (rtInf)) {
    helicopter_R2016b_DW.TimeStampB = helicopter_R2016b_M->Timing.t[0];
    lastU = &helicopter_R2016b_DW.LastUAtTimeB;
  } else if (helicopter_R2016b_DW.TimeStampA < helicopter_R2016b_DW.TimeStampB)
  {
    helicopter_R2016b_DW.TimeStampA = helicopter_R2016b_M->Timing.t[0];
    lastU = &helicopter_R2016b_DW.LastUAtTimeA;
  } else {
    helicopter_R2016b_DW.TimeStampB = helicopter_R2016b_M->Timing.t[0];
    lastU = &helicopter_R2016b_DW.LastUAtTimeB;
  }

  *lastU = helicopter_R2016b_B.PitchCounttorad;

  /* End of Update for Derivative: '<S5>/Derivative' */
  if (rtmIsMajorTimeStep(helicopter_R2016b_M)) {
    rt_ertODEUpdateContinuousStates(&helicopter_R2016b_M->solverInfo);
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++helicopter_R2016b_M->Timing.clockTick0)) {
    ++helicopter_R2016b_M->Timing.clockTickH0;
  }

  helicopter_R2016b_M->Timing.t[0] = rtsiGetSolverStopTime
    (&helicopter_R2016b_M->solverInfo);

  {
    /* Update absolute timer for sample time: [0.002s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick1"
     * and "Timing.stepSize1". Size of "clockTick1" ensures timer will not
     * overflow during the application lifespan selected.
     * Timer of this task consists of two 32 bit unsigned integers.
     * The two integers represent the low bits Timing.clockTick1 and the high bits
     * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
     */
    if (!(++helicopter_R2016b_M->Timing.clockTick1)) {
      ++helicopter_R2016b_M->Timing.clockTickH1;
    }

    helicopter_R2016b_M->Timing.t[1] = helicopter_R2016b_M->Timing.clockTick1 *
      helicopter_R2016b_M->Timing.stepSize1 +
      helicopter_R2016b_M->Timing.clockTickH1 *
      helicopter_R2016b_M->Timing.stepSize1 * 4294967296.0;
  }
}

/* Derivatives for root system: '<Root>' */
void helicopter_R2016b_derivatives(void)
{
  XDot_helicopter_R2016b_T *_rtXdot;
  boolean_T lsat;
  boolean_T usat;
  _rtXdot = ((XDot_helicopter_R2016b_T *) helicopter_R2016b_M->derivs);

  /* Derivatives for TransferFcn: '<S5>/Travel: Transfer Fcn' */
  _rtXdot->TravelTransferFcn_CSTATE = 0.0;
  _rtXdot->TravelTransferFcn_CSTATE += helicopter_R2016b_P.TravelTransferFcn_A *
    helicopter_R2016b_X.TravelTransferFcn_CSTATE;
  _rtXdot->TravelTransferFcn_CSTATE += helicopter_R2016b_B.TravelCounttorad;

  /* Derivatives for TransferFcn: '<S5>/Pitch: Transfer Fcn' */
  _rtXdot->PitchTransferFcn_CSTATE = 0.0;
  _rtXdot->PitchTransferFcn_CSTATE += helicopter_R2016b_P.PitchTransferFcn_A *
    helicopter_R2016b_X.PitchTransferFcn_CSTATE;
  _rtXdot->PitchTransferFcn_CSTATE += helicopter_R2016b_B.PitchCounttorad;

  /* Derivatives for TransferFcn: '<S5>/Elevation: Transfer Fcn' */
  _rtXdot->ElevationTransferFcn_CSTATE = 0.0;
  _rtXdot->ElevationTransferFcn_CSTATE +=
    helicopter_R2016b_P.ElevationTransferFcn_A *
    helicopter_R2016b_X.ElevationTransferFcn_CSTATE;
  _rtXdot->ElevationTransferFcn_CSTATE +=
    helicopter_R2016b_B.ElevationCounttorad;

  /* Derivatives for Integrator: '<S4>/Integrator' */
  lsat = (helicopter_R2016b_X.Integrator_CSTATE <=
          helicopter_R2016b_P.Integrator_LowerSat);
  usat = (helicopter_R2016b_X.Integrator_CSTATE >=
          helicopter_R2016b_P.Integrator_UpperSat);
  if (((!lsat) && (!usat)) || (lsat && (helicopter_R2016b_B.In1 > 0.0)) || (usat
       && (helicopter_R2016b_B.In1 < 0.0))) {
    _rtXdot->Integrator_CSTATE = helicopter_R2016b_B.In1;
  } else {
    /* in saturation */
    _rtXdot->Integrator_CSTATE = 0.0;
  }

  /* End of Derivatives for Integrator: '<S4>/Integrator' */
}

/* Model initialize function */
void helicopter_R2016b_initialize(void)
{
  /* Start for S-Function (hil_initialize_block): '<Root>/HIL Initialize' */

  /* S-Function Block: helicopter_R2016b/HIL Initialize (hil_initialize_block) */
  {
    t_int result;
    t_boolean is_switching;
    result = hil_open("q8_usb", "0", &helicopter_R2016b_DW.HILInitialize_Card);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
      return;
    }

    is_switching = false;
    result = hil_set_card_specific_options
      (helicopter_R2016b_DW.HILInitialize_Card,
       "update_rate=normal;decimation=1", 32);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
      return;
    }

    result = hil_watchdog_clear(helicopter_R2016b_DW.HILInitialize_Card);
    if (result < 0 && result != -QERR_HIL_WATCHDOG_CLEAR) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
      return;
    }

    if ((helicopter_R2016b_P.HILInitialize_AIPStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_AIPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AIMinimums = &helicopter_R2016b_DW.HILInitialize_AIMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMinimums[i1] = (helicopter_R2016b_P.HILInitialize_AILow);
        }
      }

      {
        int_T i1;
        real_T *dw_AIMaximums = &helicopter_R2016b_DW.HILInitialize_AIMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMaximums[i1] = helicopter_R2016b_P.HILInitialize_AIHigh;
        }
      }

      result = hil_set_analog_input_ranges
        (helicopter_R2016b_DW.HILInitialize_Card,
         helicopter_R2016b_P.HILInitialize_AIChannels, 8U,
         &helicopter_R2016b_DW.HILInitialize_AIMinimums[0],
         &helicopter_R2016b_DW.HILInitialize_AIMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if ((helicopter_R2016b_P.HILInitialize_AOPStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_AOPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOMinimums = &helicopter_R2016b_DW.HILInitialize_AOMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMinimums[i1] = (helicopter_R2016b_P.HILInitialize_AOLow);
        }
      }

      {
        int_T i1;
        real_T *dw_AOMaximums = &helicopter_R2016b_DW.HILInitialize_AOMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMaximums[i1] = helicopter_R2016b_P.HILInitialize_AOHigh;
        }
      }

      result = hil_set_analog_output_ranges
        (helicopter_R2016b_DW.HILInitialize_Card,
         helicopter_R2016b_P.HILInitialize_AOChannels, 8U,
         &helicopter_R2016b_DW.HILInitialize_AOMinimums[0],
         &helicopter_R2016b_DW.HILInitialize_AOMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if ((helicopter_R2016b_P.HILInitialize_AOStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_AOEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &helicopter_R2016b_DW.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = helicopter_R2016b_P.HILInitialize_AOInitial;
        }
      }

      result = hil_write_analog(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILInitialize_AOChannels, 8U,
        &helicopter_R2016b_DW.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if (helicopter_R2016b_P.HILInitialize_AOReset) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &helicopter_R2016b_DW.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = helicopter_R2016b_P.HILInitialize_AOWatchdog;
        }
      }

      result = hil_watchdog_set_analog_expiration_state
        (helicopter_R2016b_DW.HILInitialize_Card,
         helicopter_R2016b_P.HILInitialize_AOChannels, 8U,
         &helicopter_R2016b_DW.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if ((helicopter_R2016b_P.HILInitialize_EIPStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_EIPEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_QuadratureModes =
          &helicopter_R2016b_DW.HILInitialize_QuadratureModes[0];
        for (i1=0; i1 < 8; i1++) {
          dw_QuadratureModes[i1] =
            helicopter_R2016b_P.HILInitialize_EIQuadrature;
        }
      }

      result = hil_set_encoder_quadrature_mode
        (helicopter_R2016b_DW.HILInitialize_Card,
         helicopter_R2016b_P.HILInitialize_EIChannels, 8U,
         (t_encoder_quadrature_mode *)
         &helicopter_R2016b_DW.HILInitialize_QuadratureModes[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if ((helicopter_R2016b_P.HILInitialize_EIStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_EIEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_InitialEICounts =
          &helicopter_R2016b_DW.HILInitialize_InitialEICounts[0];
        for (i1=0; i1 < 8; i1++) {
          dw_InitialEICounts[i1] = helicopter_R2016b_P.HILInitialize_EIInitial;
        }
      }

      result = hil_set_encoder_counts(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILInitialize_EIChannels, 8U,
        &helicopter_R2016b_DW.HILInitialize_InitialEICounts[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if ((helicopter_R2016b_P.HILInitialize_POPStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_POPEnter && is_switching)) {
      uint32_T num_duty_cycle_modes = 0;
      uint32_T num_frequency_modes = 0;

      {
        int_T i1;
        int32_T *dw_POModeValues =
          &helicopter_R2016b_DW.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = helicopter_R2016b_P.HILInitialize_POModes;
        }
      }

      result = hil_set_pwm_mode(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILInitialize_POChannels, 8U, (t_pwm_mode *)
        &helicopter_R2016b_DW.HILInitialize_POModeValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        const uint32_T *p_HILInitialize_POChannels =
          helicopter_R2016b_P.HILInitialize_POChannels;
        int32_T *dw_POModeValues =
          &helicopter_R2016b_DW.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          if (dw_POModeValues[i1] == PWM_DUTY_CYCLE_MODE || dw_POModeValues[i1] ==
              PWM_ONE_SHOT_MODE || dw_POModeValues[i1] == PWM_TIME_MODE ||
              dw_POModeValues[i1] == PWM_RAW_MODE) {
            helicopter_R2016b_DW.HILInitialize_POSortedChans[num_duty_cycle_modes]
              = (p_HILInitialize_POChannels[i1]);
            helicopter_R2016b_DW.HILInitialize_POSortedFreqs[num_duty_cycle_modes]
              = helicopter_R2016b_P.HILInitialize_POFrequency;
            num_duty_cycle_modes++;
          } else {
            helicopter_R2016b_DW.HILInitialize_POSortedChans[7U -
              num_frequency_modes] = (p_HILInitialize_POChannels[i1]);
            helicopter_R2016b_DW.HILInitialize_POSortedFreqs[7U -
              num_frequency_modes] =
              helicopter_R2016b_P.HILInitialize_POFrequency;
            num_frequency_modes++;
          }
        }
      }

      if (num_duty_cycle_modes > 0) {
        result = hil_set_pwm_frequency(helicopter_R2016b_DW.HILInitialize_Card,
          &helicopter_R2016b_DW.HILInitialize_POSortedChans[0],
          num_duty_cycle_modes,
          &helicopter_R2016b_DW.HILInitialize_POSortedFreqs[0]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
          return;
        }
      }

      if (num_frequency_modes > 0) {
        result = hil_set_pwm_duty_cycle(helicopter_R2016b_DW.HILInitialize_Card,
          &helicopter_R2016b_DW.HILInitialize_POSortedChans[num_duty_cycle_modes],
          num_frequency_modes,
          &helicopter_R2016b_DW.HILInitialize_POSortedFreqs[num_duty_cycle_modes]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
          return;
        }
      }

      {
        int_T i1;
        int32_T *dw_POModeValues =
          &helicopter_R2016b_DW.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] =
            helicopter_R2016b_P.HILInitialize_POConfiguration;
        }
      }

      {
        int_T i1;
        int32_T *dw_POAlignValues =
          &helicopter_R2016b_DW.HILInitialize_POAlignValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POAlignValues[i1] = helicopter_R2016b_P.HILInitialize_POAlignment;
        }
      }

      {
        int_T i1;
        int32_T *dw_POPolarityVals =
          &helicopter_R2016b_DW.HILInitialize_POPolarityVals[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POPolarityVals[i1] = helicopter_R2016b_P.HILInitialize_POPolarity;
        }
      }

      result = hil_set_pwm_configuration(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILInitialize_POChannels, 8U,
        (t_pwm_configuration *)
        &helicopter_R2016b_DW.HILInitialize_POModeValues[0],
        (t_pwm_alignment *) &helicopter_R2016b_DW.HILInitialize_POAlignValues[0],
        (t_pwm_polarity *) &helicopter_R2016b_DW.HILInitialize_POPolarityVals[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        real_T *dw_POSortedFreqs =
          &helicopter_R2016b_DW.HILInitialize_POSortedFreqs[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POSortedFreqs[i1] = helicopter_R2016b_P.HILInitialize_POLeading;
        }
      }

      {
        int_T i1;
        real_T *dw_POValues = &helicopter_R2016b_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = helicopter_R2016b_P.HILInitialize_POTrailing;
        }
      }

      result = hil_set_pwm_deadband(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILInitialize_POChannels, 8U,
        &helicopter_R2016b_DW.HILInitialize_POSortedFreqs[0],
        &helicopter_R2016b_DW.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if ((helicopter_R2016b_P.HILInitialize_POStart && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_POEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &helicopter_R2016b_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = helicopter_R2016b_P.HILInitialize_POInitial;
        }
      }

      result = hil_write_pwm(helicopter_R2016b_DW.HILInitialize_Card,
        helicopter_R2016b_P.HILInitialize_POChannels, 8U,
        &helicopter_R2016b_DW.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }

    if (helicopter_R2016b_P.HILInitialize_POReset) {
      {
        int_T i1;
        real_T *dw_POValues = &helicopter_R2016b_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = helicopter_R2016b_P.HILInitialize_POWatchdog;
        }
      }

      result = hil_watchdog_set_pwm_expiration_state
        (helicopter_R2016b_DW.HILInitialize_Card,
         helicopter_R2016b_P.HILInitialize_POChannels, 8U,
         &helicopter_R2016b_DW.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        return;
      }
    }
  }

  /* Start for S-Function (hil_read_encoder_timebase_block): '<S5>/HIL Read Encoder Timebase' */

  /* S-Function Block: helicopter_R2016b/Helicopter_interface/HIL Read Encoder Timebase (hil_read_encoder_timebase_block) */
  {
    t_error result;
    result = hil_task_create_encoder_reader
      (helicopter_R2016b_DW.HILInitialize_Card,
       helicopter_R2016b_P.HILReadEncoderTimebase_SamplesI,
       helicopter_R2016b_P.HILReadEncoderTimebase_Channels, 3,
       &helicopter_R2016b_DW.HILReadEncoderTimebase_Task);
    if (result >= 0) {
      result = hil_task_set_buffer_overflow_mode
        (helicopter_R2016b_DW.HILReadEncoderTimebase_Task,
         (t_buffer_overflow_mode)
         (helicopter_R2016b_P.HILReadEncoderTimebase_Overflow - 1));
    }

    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
    }
  }

  /* Start for FromWorkspace: '<Root>/From Workspace' */
  {
    static real_T pTimeValues0[] = { 0.0, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75,
      2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0, 4.25, 4.5, 4.75, 5.0,
      5.25, 5.5, 5.75, 6.0, 6.25, 6.5, 6.75, 7.0, 7.25, 7.5, 7.75, 8.0, 8.25,
      8.5, 8.75, 9.0, 9.25, 9.5, 9.75, 10.0, 10.25, 10.5, 10.75, 11.0, 11.25,
      11.5, 11.75, 12.0, 12.25, 12.5, 12.75, 13.0, 13.25, 13.5, 13.75, 14.0,
      14.25, 14.5, 14.75, 15.0, 15.25, 15.5, 15.75, 16.0, 16.25, 16.5, 16.75,
      17.0, 17.25, 17.5, 17.75, 18.0, 18.25, 18.5, 18.75, 19.0, 19.25, 19.5,
      19.75, 20.0, 20.25, 20.5, 20.75, 21.0, 21.25, 21.5, 21.75, 22.0, 22.25,
      22.5, 22.75, 23.0, 23.25, 23.5, 23.75, 24.0, 24.25, 24.5, 24.75, 25.0,
      25.25, 25.5, 25.75, 26.0, 26.25, 26.5, 26.75, 27.0, 27.25, 27.5, 27.75,
      28.0, 28.25, 28.5, 28.75, 29.0, 29.25, 29.5, 29.75, 30.0, 30.25, 30.5,
      30.75, 31.0, 31.25, 31.5, 31.75, 32.0, 32.25, 32.5, 32.75, 33.0, 33.25,
      33.5, 33.75, 34.0, 34.25, 34.5, 34.75, 35.0 } ;

    static real_T pDataValues0[] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.52359877559826284,
      0.0704595883212582, 0.093746805470475536, 0.13089969389952749,
      0.13089969389864697, -0.041295469962760678, -0.52359877559470946,
      -0.28572136140798554, 0.00489961439821629, -0.13089969389817513,
      -0.13089969389676542, -0.13089969388939615, -0.13089969384492545,
      0.30596861360552285, 0.523598775431611, -0.33540837090523834,
      -0.19627085525075355, 0.13756940189033551, -0.015747655450757847,
      3.4515716929028883E-7, -2.6803195107838462E-8, -3.0201152800835018E-8,
      1.883032407778984E-8, -7.3766931452112772E-9, 2.7130895308147274E-9,
      -9.2135243878743722E-10, 2.2328439097663022E-10, -2.5595414676615746E-11,
      1.5472068071176182E-12, -2.6946223030677174E-12, 7.893685705084863E-13,
      3.035349749325178E-13, -1.3045120539345589E-13, -2.7533531010703882E-14,
      2.1760371282653068E-14, 1.8207657603852567E-14, -4.4408920985006262E-16,
      6.2172489379008766E-15, 9.1038288019262836E-15, 1.021405182655144E-14,
      -3.3306690738754696E-16, 1.0880185641326534E-14, 5.10702591327572E-15,
      6.106226635438361E-15, 9.9920072216264089E-15, -2.3314683517128287E-15,
      1.4432899320127035E-14, 4.9960036108132044E-15, -7.7715611723760958E-16,
      1.3211653993039363E-14, 5.440092820663267E-15, 2.2204460492503131E-15,
      5.440092820663267E-15, 1.3766765505351941E-14, -3.9968028886505635E-15,
      1.5876189252139739E-14, -5.6621374255882984E-15, 1.7430501486614958E-14,
      1.4432899320127035E-15, 2.1094237467877974E-15, 1.1324274851176597E-14,
      8.992806499463768E-15, -5.88418203051333E-15, 1.6875389974302379E-14,
      2.2204460492503131E-15, 6.3282712403633923E-15, 9.5479180117763462E-15,
      -2.7755575615628914E-15, 1.4432899320127035E-14, 3.219646771412954E-15,
      6.2172489379008766E-15, 3.9968028886505635E-15, 1.021405182655144E-14,
      -2.2204460492503131E-16, 1.2323475573339238E-14, 2.2204460492503131E-15,
      6.9944050551384862E-15, 6.7723604502134549E-15, 6.5503158452884236E-15,
      5.773159728050814E-15, 6.6613381477509392E-15, 3.6637359812630166E-15,
      8.3266726846886741E-15, 5.5511151231257827E-16, 1.5543122344752192E-14,
      -1.3322676295501878E-15, 1.0547118733938987E-14, 1.9984014443252818E-15,
      1.0325074129013956E-14, 1.4432899320127035E-15, 8.3266726846886741E-15,
      8.43769498715119E-15, 9.9920072216264089E-16, 9.8809849191638932E-15,
      5.6621374255882984E-15, 5.5511151231257827E-15, 6.8833827526759706E-15,
      -2.4312741819798589E-9, -2.581294322734351E-8, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0 } ;

    helicopter_R2016b_DW.FromWorkspace_PWORK.TimePtr = (void *) pTimeValues0;
    helicopter_R2016b_DW.FromWorkspace_PWORK.DataPtr = (void *) pDataValues0;
    helicopter_R2016b_DW.FromWorkspace_IWORK.PrevIndex = 0;
  }

  /* Start for FromWorkspace: '<Root>/From Workspace2' */
  {
    static real_T pTimeValues0[] = { 0.0, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75,
      2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0, 4.25, 4.5, 4.75, 5.0,
      5.25, 5.5, 5.75, 6.0, 6.25, 6.5, 6.75, 7.0, 7.25, 7.5, 7.75, 8.0, 8.25,
      8.5, 8.75, 9.0, 9.25, 9.5, 9.75, 10.0, 10.25, 10.5, 10.75, 11.0, 11.25,
      11.5, 11.75, 12.0, 12.25, 12.5, 12.75, 13.0, 13.25, 13.5, 13.75, 14.0,
      14.25, 14.5, 14.75, 15.0, 15.25, 15.5, 15.75, 16.0, 16.25, 16.5, 16.75,
      17.0, 17.25, 17.5, 17.75, 18.0, 18.25, 18.5, 18.75, 19.0, 19.25, 19.5,
      19.75, 20.0, 20.25, 20.5, 20.75, 21.0, 21.25, 21.5, 21.75, 22.0, 22.25,
      22.5, 22.75, 23.0, 23.25, 23.5, 23.75, 24.0, 24.25, 24.5, 24.75, 25.0,
      25.25, 25.5, 25.75, 26.0, 26.25, 26.5, 26.75, 27.0, 27.25, 27.5, 27.75,
      28.0, 28.25, 28.5, 28.75, 29.0, 29.25, 29.5, 29.75, 30.0, 30.25, 30.5,
      30.75, 31.0, 31.25, 31.5, 31.75, 32.0, 32.25, 32.5, 32.75, 33.0, 33.25,
      33.5, 33.75, 34.0, 34.25, 34.5, 34.75, 35.0 } ;

    static real_T pDataValues0[] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      -0.015002048909043523, -0.048525145853905709, -0.10056929083465113,
      -0.17113448385127786, -0.26022072490375275, -0.36289431209937645,
      -0.45990931411273583, -0.53840326809026151, -0.59837617403200594,
      -0.63982803193728066, -0.66275884180673383, -0.66716860364055441,
      -0.65305731744002793, -0.63294204783917163, -0.62682706243206054,
      -0.62831854008792987, -0.6283185272877333, -0.62831853129521886,
      -0.62831853093425172, -0.62831853057304288, -0.62831853076506239,
      -0.62831853070038912, -0.62831853072552479, -0.62831853071574406,
      -0.62831853071812294, -0.62831853071804089, -0.628318530717971,
      -0.62831853071792509, -0.62831853071794641, -0.62831853071795685,
      -0.6283185307179574, -0.62831853071795907, -0.628318530717961,
      -0.62831853071796162, -0.62831853071796162, -0.62831853071796129,
      -0.62831853071796084, -0.62831853071796029, -0.62831853071795973,
      -0.6283185307179594, -0.628318530717959, -0.62831853071795873,
      -0.62831853071795851, -0.6283185307179584, -0.62831853071795829,
      -0.62831853071795829, -0.62831853071795829, -0.6283185307179584,
      -0.6283185307179584, -0.6283185307179584, -0.62831853071795851,
      -0.62831853071795851, -0.62831853071795851, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795873, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795862, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795873, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795862, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795862, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795862, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795862, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795862, -0.62831853071795862,
      -0.62831853071795862, -0.62831853071795873, -0.62831853071795873,
      -0.62831853071795873, -0.62831853071795873, -0.62831853071795873,
      -0.62831853071795885, -0.62831853071795885, -0.628318530717959,
      -0.62831853071795885, -0.628318530717959, -0.62831853071795885,
      -0.62831853071795885, -0.62831853071795873, -0.62831853071795862,
      -0.6283185307179584, -0.62831853071795818, -0.62831853071795785,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751,
      -0.62831853071795751, -0.62831853071795751, -0.62831853071795751, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.060008195636645945, -0.13409238777974877,
      -0.20817657992326463, -0.28226077206727068, -0.35634496421075762,
      -0.41069434878253686, -0.38806000805324631, -0.31397581591006674,
      -0.23989162376712525, -0.16580743162255784, -0.0917232394774285,
      -0.017639047335556636, 0.056445144801488212, 0.0804610784044624,
      0.024459941628849104, -0.0059659106236440891, 5.1200769923322577E-8,
      -1.602991573775342E-8, 1.4438589147572802E-9, 1.4448360763732227E-9,
      -7.6807831322739831E-10, 2.5869305512607331E-10, -1.0054257995761307E-10,
      3.9122859759331277E-11, -9.5153312219656886E-12, 3.2825159653239617E-13,
      2.7990581189225638E-13, 1.8315079714690734E-13, -8.5237505600915236E-14,
      -4.1714655756635938E-14, -2.4703985441806582E-15, -6.5257586418581421E-15,
      -7.2237391268954981E-15, -2.9030269876203667E-15, 2.2862084783569596E-16,
      9.8344942574675441E-16, 1.658157911446504E-15, 2.1326833937087471E-15,
      2.057570950169334E-15, 1.4115539683763327E-15, 1.4051373341866756E-15,
      1.0648241807994031E-15, 8.3531254860124844E-16, 6.2172426189748411E-16,
      2.5558280978045516E-17, 3.9193266261368689E-16, 5.6313988588690339E-17,
      -3.83064790392472E-16, 1.0740907188806757E-16, -7.87939199106532E-17,
      -4.0407902490300578E-16, -2.0228232882199702E-16, 1.5705399186293374E-16,
      -4.0805281866313496E-16, 5.64012712985698E-17, -4.2122250373851341E-16,
      2.7372071766676974E-16, -1.28693459393967E-16, -2.6378773941731436E-16,
      1.458655963159728E-16, 4.7457914329994282E-17, -5.1001015150950206E-16,
      2.4841280155297994E-16, 3.4792289341073688E-17, -2.4875774372660303E-17,
      -3.3334915167874241E-17, -4.4276916668344149E-16, 1.4451857718736325E-16,
      -5.9948620814038136E-17, -1.306177944102533E-16, -1.6650937240602192E-16,
      5.2946450014135075E-17, -2.0215890025706289E-16, 1.7142002656012326E-16,
      -1.2098728888084274E-17, 8.7549108091815741E-17, 9.2981528370011229E-17,
      8.7415041921785051E-17, -5.841291557090797E-17, -1.6162035769498002E-16,
      -2.7783473960375128E-16, -1.5554812779129571E-16, -2.1803723947070137E-16,
      2.9870272399997731E-16, -2.070104991296484E-16, -7.2257512335680317E-17,
      -2.5083384783728781E-16, -1.0047768712970368E-17, -1.8046293173681991E-16,
      1.4902486683245179E-16, 3.1464080272666885E-16, 2.1292462100515017E-16,
      6.4694515073361271E-16, 7.85261286539784E-16, 9.2651057894663683E-16,
      1.1575814533407566E-15, 1.3554383935510951E-15, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 2.7864263486317857E-10,
      2.7864263486317857E-10, 2.7864263486317857E-10, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.42411500823458115, 0.52359877559826684, 0.52359877559821044,
      0.52359877559816848, 0.52359877559742751, 0.38412069286888406,
      -0.15997087569417268, -0.52359877559689894, -0.52359877559654955,
      -0.52359877559566814, -0.52359877559366241, -0.52359877558575363,
      -0.52359877554163936, -0.16973544646066502, 0.39579464659424579,
      0.21503830337475616, -0.04216513963564017, 4.7516109979994781E-7,
      -1.2349812550382921E-7, -6.8678396303312184E-12, 1.5640037043240795E-8,
      -7.25681925661803E-9, 2.5389463864655681E-9, -9.8709629359206019E-10,
      3.437616857837611E-10, -6.9564687343870446E-11, 3.4761082901013651E-13,
      6.8978156519960976E-13, 1.9030332865099808E-12, -3.0164759579065503E-13,
      -2.7167157412577581E-13, 3.4638958368304884E-14, 1.0880185641326534E-14,
      -2.4424906541753444E-14, -1.6209256159527285E-14, 5.5511151231257827E-16,
      1.5543122344752192E-15, 2.886579864025407E-15, 6.3282712403633923E-15,
      1.0658141036401503E-14, 5.88418203051333E-15, 8.43769498715119E-15,
      7.8825834748386114E-15, 7.3274719625260332E-15, 1.0103029524088925E-14,
      3.3306690738754696E-15, 8.5487172896137054E-15, 8.8817841970012523E-15,
      2.7755575615628914E-15, 7.4384942649885488E-15, 8.1046280797636427E-15,
      4.7739590058881731E-15, 3.5527136788005009E-15, 9.9920072216264089E-15,
      2.9976021664879227E-15, 9.3258734068513149E-15, 1.1102230246251565E-15,
      8.8817841970012523E-15, 6.8833827526759706E-15, 2.886579864025407E-15,
      6.6613381477509392E-15, 1.0103029524088925E-14, 6.6613381477509392E-16,
      7.66053886991358E-15, 6.3282712403633923E-15, 6.2172489379008766E-15,
      8.992806499463768E-15, 1.9984014443252818E-15, 7.4384942649885488E-15,
      6.5503158452884236E-15, 6.3282712403633923E-15, 4.4408920985006262E-15,
      7.66053886991358E-15, 3.219646771412954E-15, 7.5495165674510645E-15,
      5.440092820663267E-15, 5.773159728050814E-15, 6.4392935428259079E-15,
      6.9944050551384862E-15, 6.7723604502134549E-15, 7.1054273576010019E-15,
      4.9960036108132044E-15, 6.4392935428259079E-15, 2.3314683517128287E-15,
      9.6589403142388619E-15, 5.10702591327572E-15, 7.5495165674510645E-15,
      4.6629367034256575E-15, 7.5495165674510645E-15, 4.3298697960381105E-15,
      5.5511151231257827E-15, 7.9936057773011271E-15, 4.2188474935755949E-15,
      6.6613381477509392E-15, 6.8833827526759706E-15, 6.4392935428259079E-15,
      6.8833827526759706E-15, -1.9693301434031696E-9, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, -2.307475299723194E-8,
      -2.307475299723194E-8, -2.307475299723194E-8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      1.6964600329383719, 0.3979350694547088, -2.2533613766718E-13,
      -1.7281507361022547E-13, -2.9747329321156155E-12, -0.55791233091418024,
      -2.176366274252215, -1.4545115996109086, 1.3954134929996904E-12,
      3.5248300564324691E-12, 8.0229545152785538E-12, 3.1635867798855963E-11,
      1.7645791246121064E-10, 1.4154533163239889, 2.2621203722195364,
      -0.723025372877986, -1.0288137720415915, 0.16866245918696268,
      -2.3946369042192764E-6, 4.9396503337492987E-7, 6.2587618948527183E-8,
      -9.1587424655109139E-8, 3.9183063368530811E-8, -1.4104170351820832E-8,
      5.3234319135653959E-9, -1.6533053872575378E-9, 2.7964918792036188E-10,
      1.3684361891006555E-12, 4.8534186683960022E-12, -8.8186360057997956E-12,
      1.1950079354573369E-13, 1.2250637381711795E-12, -9.5020360219773777E-14,
      -1.4159843232045797E-13, 3.2763775075248962E-14, 6.71785762611196E-14,
      3.5930088525719175E-15, 5.3693490339679338E-15, 1.4053912188618408E-14,
      1.75048925824865E-14, -1.9214430049029458E-14, 9.8704614665293753E-15,
      -1.908235662740558E-15, -2.0336337004537974E-15, 1.1084747924719864E-14,
      -2.7122222154854986E-14, 2.1102868018671916E-14, 1.124483417379297E-15,
      -2.4000130487638332E-14, 1.8478949083970643E-14, 2.4816582478460193E-15,
      -1.323703686762014E-14, -5.1918621134097822E-15, 2.5662263530389671E-14,
      -2.8112906716458583E-14, 2.5683366857003556E-14, -3.2827997110370783E-14,
      3.0871128265018507E-14, -7.78520925360151E-15, -1.59042256117701E-14,
      1.478030221025435E-14, 1.3815062804289884E-14, -3.7778040617652596E-14,
      2.8019603399947287E-14, -5.2244296868250546E-15, -9.1150876626564678E-16,
      1.0928484692711639E-14, -2.7757984267101809E-14, 2.2030424456713351E-14,
      -3.4665295666424731E-15, -1.0348820078810021E-15, -7.3052070292408168E-15,
      1.2694606374087325E-14, -1.7714892349894184E-14, 1.7073624077866703E-14,
      -8.4197421532063214E-15, 1.1586086244640806E-15, 2.8526503064000769E-15,
      2.4941228740033349E-15, -8.6146104908272616E-16, 1.3149287076191416E-15,
      -8.274501961274439E-15, 5.8989577618662354E-15, -1.6466641737119768E-14,
      2.8790348563052226E-14, -1.849685033141896E-14, 9.5288022536296115E-15,
      -1.1816087957408227E-14, 1.1061198165116121E-14, -1.3280018574802854E-14,
      4.2701092354508825E-15, 8.6443665241411769E-15, -1.5797683900807589E-14,
      8.3125809051596652E-15, 2.6261568840774387E-16, -2.7106672616230596E-15,
      8.754220732603679E-16, -7.8773492260036125E-9, -8.442169362387612E-8,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9,
      -6.8470119462310522E-9, -6.8470119462310522E-9, -6.8470119462310522E-9 } ;

    helicopter_R2016b_DW.FromWorkspace2_PWORK.TimePtr = (void *) pTimeValues0;
    helicopter_R2016b_DW.FromWorkspace2_PWORK.DataPtr = (void *) pDataValues0;
    helicopter_R2016b_DW.FromWorkspace2_IWORK.PrevIndex = 0;
  }

  /* Start for If: '<S4>/If' */
  helicopter_R2016b_DW.If_ActiveSubsystem = -1;

  /* InitializeConditions for TransferFcn: '<S5>/Travel: Transfer Fcn' */
  helicopter_R2016b_X.TravelTransferFcn_CSTATE = 0.0;

  /* InitializeConditions for TransferFcn: '<S5>/Pitch: Transfer Fcn' */
  helicopter_R2016b_X.PitchTransferFcn_CSTATE = 0.0;

  /* InitializeConditions for TransferFcn: '<S5>/Elevation: Transfer Fcn' */
  helicopter_R2016b_X.ElevationTransferFcn_CSTATE = 0.0;

  /* InitializeConditions for Integrator: '<S4>/Integrator' */
  helicopter_R2016b_X.Integrator_CSTATE = helicopter_R2016b_P.Integrator_IC;

  /* InitializeConditions for Derivative: '<S5>/Derivative' */
  helicopter_R2016b_DW.TimeStampA = (rtInf);
  helicopter_R2016b_DW.TimeStampB = (rtInf);
}

/* Model terminate function */
void helicopter_R2016b_terminate(void)
{
  /* Terminate for S-Function (hil_initialize_block): '<Root>/HIL Initialize' */

  /* S-Function Block: helicopter_R2016b/HIL Initialize (hil_initialize_block) */
  {
    t_boolean is_switching;
    t_int result;
    t_uint32 num_final_analog_outputs = 0;
    t_uint32 num_final_pwm_outputs = 0;
    hil_task_stop_all(helicopter_R2016b_DW.HILInitialize_Card);
    hil_monitor_stop_all(helicopter_R2016b_DW.HILInitialize_Card);
    is_switching = false;
    if ((helicopter_R2016b_P.HILInitialize_AOTerminate && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_AOExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &helicopter_R2016b_DW.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = helicopter_R2016b_P.HILInitialize_AOFinal;
        }
      }

      num_final_analog_outputs = 8U;
    } else {
      num_final_analog_outputs = 0;
    }

    if ((helicopter_R2016b_P.HILInitialize_POTerminate && !is_switching) ||
        (helicopter_R2016b_P.HILInitialize_POExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &helicopter_R2016b_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = helicopter_R2016b_P.HILInitialize_POFinal;
        }
      }

      num_final_pwm_outputs = 8U;
    } else {
      num_final_pwm_outputs = 0;
    }

    if (0
        || num_final_analog_outputs > 0
        || num_final_pwm_outputs > 0
        ) {
      /* Attempt to write the final outputs atomically (due to firmware issue in old Q2-USB). Otherwise write channels individually */
      result = hil_write(helicopter_R2016b_DW.HILInitialize_Card
                         , helicopter_R2016b_P.HILInitialize_AOChannels,
                         num_final_analog_outputs
                         , helicopter_R2016b_P.HILInitialize_POChannels,
                         num_final_pwm_outputs
                         , NULL, 0
                         , NULL, 0
                         , &helicopter_R2016b_DW.HILInitialize_AOVoltages[0]
                         , &helicopter_R2016b_DW.HILInitialize_POValues[0]
                         , (t_boolean *) NULL
                         , NULL
                         );
      if (result == -QERR_HIL_WRITE_NOT_SUPPORTED) {
        t_error local_result;
        result = 0;

        /* The hil_write operation is not supported by this card. Write final outputs for each channel type */
        if (num_final_analog_outputs > 0) {
          local_result = hil_write_analog
            (helicopter_R2016b_DW.HILInitialize_Card,
             helicopter_R2016b_P.HILInitialize_AOChannels,
             num_final_analog_outputs,
             &helicopter_R2016b_DW.HILInitialize_AOVoltages[0]);
          if (local_result < 0) {
            result = local_result;
          }
        }

        if (num_final_pwm_outputs > 0) {
          local_result = hil_write_pwm(helicopter_R2016b_DW.HILInitialize_Card,
            helicopter_R2016b_P.HILInitialize_POChannels, num_final_pwm_outputs,
            &helicopter_R2016b_DW.HILInitialize_POValues[0]);
          if (local_result < 0) {
            result = local_result;
          }
        }

        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(helicopter_R2016b_M, _rt_error_message);
        }
      }
    }

    hil_task_delete_all(helicopter_R2016b_DW.HILInitialize_Card);
    hil_monitor_delete_all(helicopter_R2016b_DW.HILInitialize_Card);
    hil_close(helicopter_R2016b_DW.HILInitialize_Card);
    helicopter_R2016b_DW.HILInitialize_Card = NULL;
  }
}

/*========================================================================*
 * Start of Classic call interface                                        *
 *========================================================================*/

/* Solver interface called by GRT_Main */
#ifndef USE_GENERATED_SOLVER

void rt_ODECreateIntegrationData(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

void rt_ODEDestroyIntegrationData(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

void rt_ODEUpdateContinuousStates(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

#endif

void MdlOutputs(int_T tid)
{
  helicopter_R2016b_output();
  UNUSED_PARAMETER(tid);
}

void MdlUpdate(int_T tid)
{
  helicopter_R2016b_update();
  UNUSED_PARAMETER(tid);
}

void MdlInitializeSizes(void)
{
}

void MdlInitializeSampleTimes(void)
{
}

void MdlInitialize(void)
{
}

void MdlStart(void)
{
  helicopter_R2016b_initialize();
}

void MdlTerminate(void)
{
  helicopter_R2016b_terminate();
}

/* Registration function */
RT_MODEL_helicopter_R2016b_T *helicopter_R2016b(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  /* non-finite (run-time) assignments */
  helicopter_R2016b_P.Integrator_UpperSat = rtInf;
  helicopter_R2016b_P.Integrator_LowerSat = rtMinusInf;

  /* initialize real-time model */
  (void) memset((void *)helicopter_R2016b_M, 0,
                sizeof(RT_MODEL_helicopter_R2016b_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&helicopter_R2016b_M->solverInfo,
                          &helicopter_R2016b_M->Timing.simTimeStep);
    rtsiSetTPtr(&helicopter_R2016b_M->solverInfo, &rtmGetTPtr
                (helicopter_R2016b_M));
    rtsiSetStepSizePtr(&helicopter_R2016b_M->solverInfo,
                       &helicopter_R2016b_M->Timing.stepSize0);
    rtsiSetdXPtr(&helicopter_R2016b_M->solverInfo, &helicopter_R2016b_M->derivs);
    rtsiSetContStatesPtr(&helicopter_R2016b_M->solverInfo, (real_T **)
                         &helicopter_R2016b_M->contStates);
    rtsiSetNumContStatesPtr(&helicopter_R2016b_M->solverInfo,
      &helicopter_R2016b_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&helicopter_R2016b_M->solverInfo,
      &helicopter_R2016b_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&helicopter_R2016b_M->solverInfo,
      &helicopter_R2016b_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&helicopter_R2016b_M->solverInfo,
      &helicopter_R2016b_M->periodicContStateRanges);
    rtsiSetErrorStatusPtr(&helicopter_R2016b_M->solverInfo, (&rtmGetErrorStatus
      (helicopter_R2016b_M)));
    rtsiSetRTModelPtr(&helicopter_R2016b_M->solverInfo, helicopter_R2016b_M);
  }

  rtsiSetSimTimeStep(&helicopter_R2016b_M->solverInfo, MAJOR_TIME_STEP);
  helicopter_R2016b_M->intgData.f[0] = helicopter_R2016b_M->odeF[0];
  helicopter_R2016b_M->contStates = ((real_T *) &helicopter_R2016b_X);
  rtsiSetSolverData(&helicopter_R2016b_M->solverInfo, (void *)
                    &helicopter_R2016b_M->intgData);
  rtsiSetSolverName(&helicopter_R2016b_M->solverInfo,"ode1");

  /* Initialize timing info */
  {
    int_T *mdlTsMap = helicopter_R2016b_M->Timing.sampleTimeTaskIDArray;
    mdlTsMap[0] = 0;
    mdlTsMap[1] = 1;
    helicopter_R2016b_M->Timing.sampleTimeTaskIDPtr = (&mdlTsMap[0]);
    helicopter_R2016b_M->Timing.sampleTimes =
      (&helicopter_R2016b_M->Timing.sampleTimesArray[0]);
    helicopter_R2016b_M->Timing.offsetTimes =
      (&helicopter_R2016b_M->Timing.offsetTimesArray[0]);

    /* task periods */
    helicopter_R2016b_M->Timing.sampleTimes[0] = (0.0);
    helicopter_R2016b_M->Timing.sampleTimes[1] = (0.002);

    /* task offsets */
    helicopter_R2016b_M->Timing.offsetTimes[0] = (0.0);
    helicopter_R2016b_M->Timing.offsetTimes[1] = (0.0);
  }

  rtmSetTPtr(helicopter_R2016b_M, &helicopter_R2016b_M->Timing.tArray[0]);

  {
    int_T *mdlSampleHits = helicopter_R2016b_M->Timing.sampleHitArray;
    mdlSampleHits[0] = 1;
    mdlSampleHits[1] = 1;
    helicopter_R2016b_M->Timing.sampleHits = (&mdlSampleHits[0]);
  }

  rtmSetTFinal(helicopter_R2016b_M, -1);
  helicopter_R2016b_M->Timing.stepSize0 = 0.002;
  helicopter_R2016b_M->Timing.stepSize1 = 0.002;

  /* External mode info */
  helicopter_R2016b_M->Sizes.checksums[0] = (4221897665U);
  helicopter_R2016b_M->Sizes.checksums[1] = (1519010034U);
  helicopter_R2016b_M->Sizes.checksums[2] = (1884663839U);
  helicopter_R2016b_M->Sizes.checksums[3] = (3369939257U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[3];
    helicopter_R2016b_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = (sysRanDType *)
      &helicopter_R2016b_DW.IfActionSubsystem_SubsysRanBC;
    systemRan[2] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(helicopter_R2016b_M->extModeInfo,
      &helicopter_R2016b_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(helicopter_R2016b_M->extModeInfo,
                        helicopter_R2016b_M->Sizes.checksums);
    rteiSetTPtr(helicopter_R2016b_M->extModeInfo, rtmGetTPtr(helicopter_R2016b_M));
  }

  helicopter_R2016b_M->solverInfoPtr = (&helicopter_R2016b_M->solverInfo);
  helicopter_R2016b_M->Timing.stepSize = (0.002);
  rtsiSetFixedStepSize(&helicopter_R2016b_M->solverInfo, 0.002);
  rtsiSetSolverMode(&helicopter_R2016b_M->solverInfo, SOLVER_MODE_SINGLETASKING);

  /* block I/O */
  helicopter_R2016b_M->blockIO = ((void *) &helicopter_R2016b_B);

  {
    int32_T i;
    for (i = 0; i < 6; i++) {
      helicopter_R2016b_B.Gain1[i] = 0.0;
    }

    helicopter_R2016b_B.TravelCounttorad = 0.0;
    helicopter_R2016b_B.Gain = 0.0;
    helicopter_R2016b_B.Gain_d = 0.0;
    helicopter_R2016b_B.PitchCounttorad = 0.0;
    helicopter_R2016b_B.Gain_i = 0.0;
    helicopter_R2016b_B.Gain_b = 0.0;
    helicopter_R2016b_B.ElevationCounttorad = 0.0;
    helicopter_R2016b_B.Gain_e = 0.0;
    helicopter_R2016b_B.Sum = 0.0;
    helicopter_R2016b_B.Gain_dg = 0.0;
    helicopter_R2016b_B.FromWorkspace = 0.0;
    helicopter_R2016b_B.FromWorkspace2[0] = 0.0;
    helicopter_R2016b_B.FromWorkspace2[1] = 0.0;
    helicopter_R2016b_B.FromWorkspace2[2] = 0.0;
    helicopter_R2016b_B.FromWorkspace2[3] = 0.0;
    helicopter_R2016b_B.Sum4 = 0.0;
    helicopter_R2016b_B.Gain1_m = 0.0;
    helicopter_R2016b_B.Gain_l = 0.0;
    helicopter_R2016b_B.BackmotorSaturation = 0.0;
    helicopter_R2016b_B.FrontmotorSaturation = 0.0;
    helicopter_R2016b_B.In1 = 0.0;
  }

  /* parameters */
  helicopter_R2016b_M->defaultParam = ((real_T *)&helicopter_R2016b_P);

  /* states (continuous) */
  {
    real_T *x = (real_T *) &helicopter_R2016b_X;
    helicopter_R2016b_M->contStates = (x);
    (void) memset((void *)&helicopter_R2016b_X, 0,
                  sizeof(X_helicopter_R2016b_T));
  }

  /* states (dwork) */
  helicopter_R2016b_M->dwork = ((void *) &helicopter_R2016b_DW);
  (void) memset((void *)&helicopter_R2016b_DW, 0,
                sizeof(DW_helicopter_R2016b_T));

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_AIMinimums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_AIMaximums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_AOMinimums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_AOMaximums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_AOVoltages[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_FilterFrequency[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_POSortedFreqs[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      helicopter_R2016b_DW.HILInitialize_POValues[i] = 0.0;
    }
  }

  helicopter_R2016b_DW.TimeStampA = 0.0;
  helicopter_R2016b_DW.LastUAtTimeA = 0.0;
  helicopter_R2016b_DW.TimeStampB = 0.0;
  helicopter_R2016b_DW.LastUAtTimeB = 0.0;
  helicopter_R2016b_DW.HILWriteAnalog_Buffer[0] = 0.0;
  helicopter_R2016b_DW.HILWriteAnalog_Buffer[1] = 0.0;

  /* data type transition information */
  {
    static DataTypeTransInfo dtInfo;
    (void) memset((char_T *) &dtInfo, 0,
                  sizeof(dtInfo));
    helicopter_R2016b_M->SpecialInfo.mappingInfo = (&dtInfo);
    dtInfo.numDataTypes = 16;
    dtInfo.dataTypeSizes = &rtDataTypeSizes[0];
    dtInfo.dataTypeNames = &rtDataTypeNames[0];

    /* Block I/O transition table */
    dtInfo.BTransTable = &rtBTransTable;

    /* Parameters transition table */
    dtInfo.PTransTable = &rtPTransTable;
  }

  /* Initialize Sizes */
  helicopter_R2016b_M->Sizes.numContStates = (4);/* Number of continuous states */
  helicopter_R2016b_M->Sizes.numPeriodicContStates = (0);
                                      /* Number of periodic continuous states */
  helicopter_R2016b_M->Sizes.numY = (0);/* Number of model outputs */
  helicopter_R2016b_M->Sizes.numU = (0);/* Number of model inputs */
  helicopter_R2016b_M->Sizes.sysDirFeedThru = (0);/* The model is not direct feedthrough */
  helicopter_R2016b_M->Sizes.numSampTimes = (2);/* Number of sample times */
  helicopter_R2016b_M->Sizes.numBlocks = (80);/* Number of blocks */
  helicopter_R2016b_M->Sizes.numBlockIO = (19);/* Number of block outputs */
  helicopter_R2016b_M->Sizes.numBlockPrms = (152);/* Sum of parameter "widths" */
  return helicopter_R2016b_M;
}

/*========================================================================*
 * End of Classic call interface                                          *
 *========================================================================*/
