SAMPLE_DIR = "strictly_open_loop";

timestamp = datestr(now, "yyyy-mm-dd HH-MM-ss");

folder = strcat(SAMPLE_DIR, '/', timestamp, '/');

mkdir(SAMPLE_DIR, timestamp)

variables = [
%     "q", "lambda", "r", "p", "pdot", "u"... % Our own file
    "ut", "sim_travel", "sim_travel_dot", "sim_pitch", "sim_pitch_dot", "sim_elevation", "sim_elevation_dot"...
    "x1", "x2", "x3", "x4", "u"... % Template file
];

for i = 1:numel(variables)
    file = strcat(folder, variables(i), ".mat");
    save(file, variables(i));
end

files_to_cp = [
%     "lab_day_2.m"
    "init.m"
    "template_problem_2.m"
    "README"
];

for i = 1:numel(files_to_cp)
    dest = strcat(folder, files_to_cp(i));
    copyfile(files_to_cp(i), dest);
end

open(strcat(folder, '/README'))