SAMPLE_DIR = "kalman_filter_tests";

timestamp = datestr(now, "yyyy-mm-dd HH-MM-ss");

folder = strcat(SAMPLE_DIR, '/', timestamp, '/');

mkdir(SAMPLE_DIR, timestamp)

variables = [
    "e", "ed", "p", "pd", "rp", "red", "vs", "vd"...
    "IMU_p", "IMU_e", "IMU_euler_pd", "IMU_euler_ed", "IMU_euler_td"... 
    "p_hat_luenberger", "pd_hat_luenberger", "e_hat_luenberger", "ed_hat_luenberger", "td_hat_luenberger"...
    "p_hat_kalman", "pd_hat_kalman", "e_hat_kalman", "ed_hat_kalman", "td_hat_kalman"...
    "p_hat", "pd_hat", "e_hat", "ed_hat", "td_hat"...
];

for i = 1:numel(variables)
    file = strcat(folder, variables(i), ".mat");
    save(file, variables(i));
end

files_to_cp = ["init_heli_3_10.m", "README"];

for i = 1:numel(files_to_cp)
    dest = strcat(folder, files_to_cp(i));
    copyfile(files_to_cp(i), dest);
end

open(strcat(folder, '/README'))