/*
 * heli_q8.c
 *
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * Code generation for model "heli_q8".
 *
 * Model version              : 11.202
 * Simulink Coder version : 9.4 (R2020b) 29-Jul-2020
 * C source code generated on : Thu Nov  7 11:16:45 2024
 *
 * Target selection: quarc_win64.tlc
 * Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: 32-bit Generic
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "heli_q8.h"
#include "heli_q8_private.h"
#include "heli_q8_dt.h"

t_stream heli_q8_rtZt_stream = NULL;

/* Block signals (default storage) */
B_heli_q8_T heli_q8_B;

/* Continuous states */
X_heli_q8_T heli_q8_X;

/* Block states (default storage) */
DW_heli_q8_T heli_q8_DW;

/* Real-time model */
static RT_MODEL_heli_q8_T heli_q8_M_;
RT_MODEL_heli_q8_T *const heli_q8_M = &heli_q8_M_;

/* Forward declaration for local functions */
static void heli_q8_mpower(const real_T a[36], real_T c[36]);
static void rate_monotonic_scheduler(void);
time_T rt_SimUpdateDiscreteEvents(
  int_T rtmNumSampTimes, void *rtmTimingData, int_T *rtmSampleHitPtr, int_T
  *rtmPerTaskSampleHits )
{
  rtmSampleHitPtr[1] = rtmStepTask(heli_q8_M, 1);
  rtmSampleHitPtr[2] = rtmStepTask(heli_q8_M, 2);
  UNUSED_PARAMETER(rtmNumSampTimes);
  UNUSED_PARAMETER(rtmTimingData);
  UNUSED_PARAMETER(rtmPerTaskSampleHits);
  return(-1);
}

/*
 *   This function updates active task flag for each subrate
 * and rate transition flags for tasks that exchange data.
 * The function assumes rate-monotonic multitasking scheduler.
 * The function must be called at model base rate so that
 * the generated code self-manages all its subrates and rate
 * transition flags.
 */
static void rate_monotonic_scheduler(void)
{
  /* To ensure a deterministic data transfer between two rates,
   * data is transferred at the priority of a fast task and the frequency
   * of the slow task.  The following flags indicate when the data transfer
   * happens.  That is, a rate interaction flag is set true when both rates
   * will run, and false otherwise.
   */

  /* tid 1 shares data with slower tid rate: 2 */
  if (heli_q8_M->Timing.TaskCounters.TID[1] == 0) {
    heli_q8_M->Timing.RateInteraction.TID1_2 =
      (heli_q8_M->Timing.TaskCounters.TID[2] == 0);

    /* update PerTaskSampleHits matrix for non-inline sfcn */
    heli_q8_M->Timing.perTaskSampleHits[5] =
      heli_q8_M->Timing.RateInteraction.TID1_2;
  }

  /* Compute which subrates run during the next base time step.  Subrates
   * are an integer multiple of the base rate counter.  Therefore, the subtask
   * counter is reset when it reaches its limit (zero means run).
   */
  (heli_q8_M->Timing.TaskCounters.TID[2])++;
  if ((heli_q8_M->Timing.TaskCounters.TID[2]) > 4) {/* Sample time: [0.01s, 0.0s] */
    heli_q8_M->Timing.TaskCounters.TID[2] = 0;
  }
}

/*
 * This function updates continuous states using the ODE1 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE1_IntgData *id = (ODE1_IntgData *)rtsiGetSolverData(si);
  real_T *f0 = id->f[0];
  int_T i;
  int_T nXc = 10;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);
  rtsiSetdX(si, f0);
  heli_q8_derivatives();
  rtsiSetT(si, tnew);
  for (i = 0; i < nXc; ++i) {
    x[i] += h * f0[i];
  }

  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

real_T rt_atan2d_snf(real_T u0, real_T u1)
{
  real_T y;
  int32_T u0_0;
  int32_T u1_0;
  if (rtIsNaN(u0) || rtIsNaN(u1)) {
    y = (rtNaN);
  } else if (rtIsInf(u0) && rtIsInf(u1)) {
    if (u0 > 0.0) {
      u0_0 = 1;
    } else {
      u0_0 = -1;
    }

    if (u1 > 0.0) {
      u1_0 = 1;
    } else {
      u1_0 = -1;
    }

    y = atan2(u0_0, u1_0);
  } else if (u1 == 0.0) {
    if (u0 > 0.0) {
      y = RT_PI / 2.0;
    } else if (u0 < 0.0) {
      y = -(RT_PI / 2.0);
    } else {
      y = 0.0;
    }
  } else {
    y = atan2(u0, u1);
  }

  return y;
}

/* Function for MATLAB Function: '<S5>/Kalman posterior' */
static void heli_q8_mpower(const real_T a[36], real_T c[36])
{
  real_T A[36];
  real_T smax;
  real_T y;
  int32_T c_ix;
  int32_T c_j;
  int32_T d;
  int32_T d_k;
  int32_T ijA;
  int32_T ix;
  int32_T iy;
  int32_T pipk;
  int8_T ipiv[6];
  int8_T p[6];
  int8_T ipiv_0;
  for (d_k = 0; d_k < 36; d_k++) {
    c[d_k] = 0.0;
    A[d_k] = a[d_k];
  }

  for (d_k = 0; d_k < 6; d_k++) {
    ipiv[d_k] = (int8_T)(d_k + 1);
  }

  for (c_j = 0; c_j < 5; c_j++) {
    pipk = c_j * 7;
    iy = 0;
    ix = pipk;
    smax = fabs(A[pipk]);
    for (d_k = 2; d_k <= 6 - c_j; d_k++) {
      ix++;
      y = fabs(A[ix]);
      if (y > smax) {
        iy = d_k - 1;
        smax = y;
      }
    }

    if (A[pipk + iy] != 0.0) {
      if (iy != 0) {
        iy += c_j;
        ipiv[c_j] = (int8_T)(iy + 1);
        ix = c_j;
        for (d_k = 0; d_k < 6; d_k++) {
          smax = A[ix];
          A[ix] = A[iy];
          A[iy] = smax;
          ix += 6;
          iy += 6;
        }
      }

      iy = (pipk - c_j) + 6;
      for (ix = pipk + 1; ix < iy; ix++) {
        A[ix] /= A[pipk];
      }
    }

    iy = pipk;
    ix = pipk + 6;
    for (d_k = 0; d_k <= 4 - c_j; d_k++) {
      if (A[ix] != 0.0) {
        smax = -A[ix];
        c_ix = pipk + 1;
        d = (iy - c_j) + 12;
        for (ijA = iy + 7; ijA < d; ijA++) {
          A[ijA] += A[c_ix] * smax;
          c_ix++;
        }
      }

      ix += 6;
      iy += 6;
    }
  }

  for (d_k = 0; d_k < 6; d_k++) {
    p[d_k] = (int8_T)(d_k + 1);
  }

  for (c_j = 0; c_j < 5; c_j++) {
    ipiv_0 = ipiv[c_j];
    if (ipiv_0 > c_j + 1) {
      pipk = p[ipiv_0 - 1];
      p[ipiv_0 - 1] = p[c_j];
      p[c_j] = (int8_T)pipk;
    }
  }

  for (c_j = 0; c_j < 6; c_j++) {
    pipk = p[c_j] - 1;
    c[c_j + 6 * pipk] = 1.0;
    for (iy = c_j; iy + 1 < 7; iy++) {
      d_k = 6 * pipk + iy;
      if (c[d_k] != 0.0) {
        for (ix = iy + 1; ix + 1 < 7; ix++) {
          c_ix = 6 * pipk + ix;
          c[c_ix] -= c[d_k] * A[6 * iy + ix];
        }
      }
    }
  }

  for (c_j = 0; c_j < 6; c_j++) {
    pipk = 6 * c_j;
    for (iy = 5; iy >= 0; iy--) {
      ix = 6 * iy;
      d_k = iy + pipk;
      smax = c[d_k];
      if (smax != 0.0) {
        c[d_k] = smax / A[iy + ix];
        for (d_k = 0; d_k < iy; d_k++) {
          c_ix = d_k + pipk;
          c[c_ix] -= c[iy + pipk] * A[d_k + ix];
        }
      }
    }
  }
}

/* Model output function for TID0 */
void heli_q8_output0(void)             /* Sample time: [0.0s, 0.0s] */
{
  /* local block i/o variables */
  t_stream_ptr rtb_StreamCall1_o1;
  real_T rtb_HILReadEncoderTimebase_o1;
  real_T rtb_HILReadEncoderTimebase_o2;
  real_T rtb_HILReadEncoderTimebase_o3;
  real32_T rtb_StreamRead1_o2[10];
  int32_T rtb_StreamFormattedWrite_o2;
  int32_T rtb_StreamCall1_o3;
  real_T L_tmp[36];
  real_T L_tmp_0[36];
  real_T P_hat_tmp[36];
  real_T b_0[36];
  real_T b_1[36];
  real_T tmp_1[36];
  real_T tmp_7[9];
  real_T tmp_0[6];
  real_T tmp_2[6];
  real_T tmp_3[6];
  real_T rtb_Sum8[5];
  real_T tmp_4[5];
  real_T tmp_5[5];
  real_T tmp_6[5];
  real_T rtb_Gain2[3];
  real_T tmp[2];
  real_T euler_rates_tmp;
  real_T rtb_Backgain;
  real_T rtb_Switch4_idx_0;
  real_T rtb_Switch4_idx_2;
  real_T rtb_TmpSignalConversionAtSFun_0;
  real_T rtb_TmpSignalConversionAtSFun_1;
  int32_T L_tmp_tmp;
  int32_T P_bar_tmp;
  int32_T b_tmp;
  int32_T b_tmp_0;
  int32_T i;
  int32_T i_0;
  int8_T b[36];
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* set solver stop time */
    if (!(heli_q8_M->Timing.clockTick0+1)) {
      rtsiSetSolverStopTime(&heli_q8_M->solverInfo,
                            ((heli_q8_M->Timing.clockTickH0 + 1) *
        heli_q8_M->Timing.stepSize0 * 4294967296.0));
    } else {
      rtsiSetSolverStopTime(&heli_q8_M->solverInfo,
                            ((heli_q8_M->Timing.clockTick0 + 1) *
        heli_q8_M->Timing.stepSize0 + heli_q8_M->Timing.clockTickH0 *
        heli_q8_M->Timing.stepSize0 * 4294967296.0));
    }

    {                                  /* Sample time: [0.0s, 0.0s] */
      rate_monotonic_scheduler();
    }
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(heli_q8_M)) {
    heli_q8_M->Timing.t[0] = rtsiGetT(&heli_q8_M->solverInfo);
  }

  /* RateTransition: '<S12>/Rate Transition: x' incorporates:
   *  RateTransition: '<S12>/Rate Transition: y1'
   */
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* S-Function (hil_read_encoder_timebase_block): '<S3>/HIL Read Encoder Timebase' */

    /* S-Function Block: heli_q8/Heli 3D/HIL Read Encoder Timebase (hil_read_encoder_timebase_block) */
    {
      t_error result;
      result = hil_task_read_encoder(heli_q8_DW.HILReadEncoderTimebase_Task, 1,
        &heli_q8_DW.HILReadEncoderTimebase_Buffer[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
      } else {
        rtb_HILReadEncoderTimebase_o1 =
          heli_q8_DW.HILReadEncoderTimebase_Buffer[0];
        rtb_HILReadEncoderTimebase_o2 =
          heli_q8_DW.HILReadEncoderTimebase_Buffer[1];
        rtb_HILReadEncoderTimebase_o3 =
          heli_q8_DW.HILReadEncoderTimebase_Buffer[2];
      }
    }

    if (heli_q8_M->Timing.RateInteraction.TID1_2) {
      /* RateTransition: '<S12>/Rate Transition: x' */
      heli_q8_B.RateTransitionx = heli_q8_DW.RateTransitionx_Buffer0;
    }

    /* DeadZone: '<S12>/Dead Zone: x' */
    if (heli_q8_B.RateTransitionx > heli_q8_P.DeadZonex_End) {
      rtb_Backgain = heli_q8_B.RateTransitionx - heli_q8_P.DeadZonex_End;
    } else if (heli_q8_B.RateTransitionx >= heli_q8_P.DeadZonex_Start) {
      rtb_Backgain = 0.0;
    } else {
      rtb_Backgain = heli_q8_B.RateTransitionx - heli_q8_P.DeadZonex_Start;
    }

    /* End of DeadZone: '<S12>/Dead Zone: x' */

    /* Gain: '<S12>/Joystick_gain_x' incorporates:
     *  Gain: '<S12>/Gain: x'
     */
    heli_q8_B.Joystick_gain_x = heli_q8_P.Gainx_Gain * rtb_Backgain *
      heli_q8_P.Joystick_gain_x;
    if (heli_q8_M->Timing.RateInteraction.TID1_2) {
      /* RateTransition: '<S12>/Rate Transition: y1' */
      heli_q8_B.RateTransitiony1[0] = heli_q8_DW.RateTransitiony1_Buffer0[0];
      heli_q8_B.RateTransitiony1[1] = heli_q8_DW.RateTransitiony1_Buffer0[1];
    }
  }

  /* End of RateTransition: '<S12>/Rate Transition: x' */

  /* Switch: '<S4>/Switch1' incorporates:
   *  Constant: '<S4>/automatic control'
   *  Gain: '<S4>/Gain1'
   *  Sum: '<S4>/Sum6'
   */
  if (heli_q8_P.automaticcontrol_Value > heli_q8_P.Switch1_Threshold) {
    /* Step: '<S4>/Step2' incorporates:
     *  Step: '<S4>/Step3'
     */
    rtb_Backgain = heli_q8_M->Timing.t[0];
    if (rtb_Backgain < heli_q8_P.x_unit_step_start_time) {
      rtb_Switch4_idx_0 = heli_q8_P.Step2_Y0;
    } else {
      rtb_Switch4_idx_0 = heli_q8_P.Step2_YFinal;
    }

    /* End of Step: '<S4>/Step2' */

    /* Step: '<S4>/Step3' */
    if (rtb_Backgain < heli_q8_P.x_unit_step_start_time +
        heli_q8_P.x_unit_step_length) {
      rtb_Backgain = heli_q8_P.Step3_Y0;
    } else {
      rtb_Backgain = heli_q8_P.Step3_YFinal;
    }

    rtb_Backgain = (rtb_Switch4_idx_0 + rtb_Backgain) *
      heli_q8_P.x_unit_step_gain;
  } else {
    rtb_Backgain = heli_q8_B.Joystick_gain_x;
  }

  /* End of Switch: '<S4>/Switch1' */

  /* Product: '<S4>/Product1' */
  heli_q8_B.Product1 = rtb_Backgain * heli_q8_B.RateTransitiony1[0];

  /* RateTransition: '<S12>/Rate Transition: y' */
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    if (heli_q8_M->Timing.RateInteraction.TID1_2) {
      /* RateTransition: '<S12>/Rate Transition: y' */
      heli_q8_B.RateTransitiony = heli_q8_DW.RateTransitiony_Buffer0;
    }

    /* DeadZone: '<S12>/Dead Zone: y' */
    if (heli_q8_B.RateTransitiony > heli_q8_P.DeadZoney_End) {
      rtb_Backgain = heli_q8_B.RateTransitiony - heli_q8_P.DeadZoney_End;
    } else if (heli_q8_B.RateTransitiony >= heli_q8_P.DeadZoney_Start) {
      rtb_Backgain = 0.0;
    } else {
      rtb_Backgain = heli_q8_B.RateTransitiony - heli_q8_P.DeadZoney_Start;
    }

    /* End of DeadZone: '<S12>/Dead Zone: y' */

    /* Gain: '<S12>/Joystick_gain_y' incorporates:
     *  Gain: '<S12>/Gain: y'
     */
    heli_q8_B.Joystick_gain_y = heli_q8_P.Gainy_Gain * rtb_Backgain *
      heli_q8_P.Joystick_gain_y;
  }

  /* End of RateTransition: '<S12>/Rate Transition: y' */

  /* Switch: '<S4>/Switch' incorporates:
   *  Constant: '<S4>/automatic control'
   *  Gain: '<S4>/Gain'
   *  Sum: '<S4>/Sum5'
   */
  if (heli_q8_P.automaticcontrol_Value > heli_q8_P.Switch_Threshold) {
    /* Step: '<S4>/Step' incorporates:
     *  Step: '<S4>/Step1'
     */
    rtb_Backgain = heli_q8_M->Timing.t[0];
    if (rtb_Backgain < heli_q8_P.y_unit_step_start_time) {
      rtb_Switch4_idx_0 = heli_q8_P.Step_Y0;
    } else {
      rtb_Switch4_idx_0 = heli_q8_P.Step_YFinal;
    }

    /* End of Step: '<S4>/Step' */

    /* Step: '<S4>/Step1' */
    if (rtb_Backgain < heli_q8_P.y_unit_step_start_time +
        heli_q8_P.y_unit_step_length) {
      rtb_Backgain = heli_q8_P.Step1_Y0;
    } else {
      rtb_Backgain = heli_q8_P.Step1_YFinal;
    }

    rtb_Backgain = (rtb_Switch4_idx_0 + rtb_Backgain) *
      heli_q8_P.y_unit_step_gain;
  } else {
    rtb_Backgain = heli_q8_B.Joystick_gain_y;
  }

  /* End of Switch: '<S4>/Switch' */

  /* Product: '<S4>/Product' */
  heli_q8_B.Product = rtb_Backgain * heli_q8_B.RateTransitiony1[0];
  for (i = 0; i < 5; i++) {
    /* Integrator: '<S7>/Integrator2' */
    heli_q8_B.x_hat[i] = heli_q8_X.Integrator2_CSTATE[i];
  }

  if (rtmIsMajorTimeStep(heli_q8_M)) {
    for (i = 0; i < 6; i++) {
      /* UnitDelay: '<S5>/Unit Delay' */
      heli_q8_B.UnitDelay[i] = heli_q8_DW.UnitDelay_DSTATE[i];
    }

    /* Gain: '<S3>/Pitch: Count to rad' */
    heli_q8_B.PitchCounttorad = heli_q8_P.PitchCounttorad_Gain *
      rtb_HILReadEncoderTimebase_o2;
  }

  /* Switch: '<S9>/Switch5' incorporates:
   *  Constant: '<S9>/Luenberger//Kalman select'
   */
  if (heli_q8_P.LuenbergerKalmanselect_Value > heli_q8_P.Switch5_Threshold) {
    /* Switch: '<S9>/Switch5' */
    heli_q8_B.Switch5[0] = heli_q8_B.x_hat[0];
    heli_q8_B.Switch5[1] = heli_q8_B.x_hat[1];
    heli_q8_B.Switch5[2] = heli_q8_B.x_hat[2];
    heli_q8_B.Switch5[3] = heli_q8_B.x_hat[3];
    heli_q8_B.Switch5[4] = heli_q8_B.x_hat[4];
  } else {
    /* Switch: '<S9>/Switch5' */
    heli_q8_B.Switch5[0] = heli_q8_B.UnitDelay[0];
    heli_q8_B.Switch5[1] = heli_q8_B.UnitDelay[1];
    heli_q8_B.Switch5[2] = heli_q8_B.UnitDelay[2];
    heli_q8_B.Switch5[3] = heli_q8_B.UnitDelay[3];
    heli_q8_B.Switch5[4] = heli_q8_B.UnitDelay[5];
  }

  /* End of Switch: '<S9>/Switch5' */

  /* TransferFcn: '<S3>/Pitch: Transfer Fcn' */
  heli_q8_B.PitchTransferFcn = 0.0;
  heli_q8_B.PitchTransferFcn += heli_q8_P.PitchTransferFcn_C *
    heli_q8_X.PitchTransferFcn_CSTATE;
  heli_q8_B.PitchTransferFcn += heli_q8_P.PitchTransferFcn_D *
    heli_q8_B.PitchCounttorad;
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* Gain: '<S3>/Elevation: Count to rad' */
    heli_q8_B.ElevationCounttorad = heli_q8_P.ElevationCounttorad_Gain *
      rtb_HILReadEncoderTimebase_o3;
  }

  /* TransferFcn: '<S3>/Elevation: Transfer Fcn' */
  heli_q8_B.ElevationTransferFcn = 0.0;
  heli_q8_B.ElevationTransferFcn += heli_q8_P.ElevationTransferFcn_C *
    heli_q8_X.ElevationTransferFcn_CSTATE;
  heli_q8_B.ElevationTransferFcn += heli_q8_P.ElevationTransferFcn_D *
    heli_q8_B.ElevationCounttorad;

  /* Switch: '<S11>/Switch4' incorporates:
   *  Constant: '<S11>/x hat on'
   */
  if (heli_q8_P.xhaton_Value > heli_q8_P.Switch4_Threshold) {
    rtb_Switch4_idx_0 = heli_q8_B.Switch5[0];

    /* SignalConversion generated from: '<S6>/Matrix Multiply' */
    rtb_Sum8[1] = heli_q8_B.Switch5[1];
    rtb_Switch4_idx_2 = heli_q8_B.Switch5[3];
  } else {
    rtb_Switch4_idx_0 = heli_q8_B.PitchCounttorad;

    /* SignalConversion generated from: '<S6>/Matrix Multiply' */
    rtb_Sum8[1] = heli_q8_B.PitchTransferFcn;
    rtb_Switch4_idx_2 = heli_q8_B.ElevationTransferFcn;
  }

  /* End of Switch: '<S11>/Switch4' */

  /* SignalConversion generated from: '<S6>/Matrix Multiply' incorporates:
   *  Integrator: '<S6>/Integrator'
   *  Integrator: '<S6>/Integrator1'
   */
  rtb_Sum8[0] = rtb_Switch4_idx_0;
  rtb_Sum8[2] = rtb_Switch4_idx_2;
  rtb_Sum8[3] = heli_q8_X.Integrator_CSTATE;
  rtb_Sum8[4] = heli_q8_X.Integrator1_CSTATE;
  for (i = 0; i < 2; i++) {
    /* Product: '<S6>/Matrix Multiply' incorporates:
     *  Constant: '<S6>/Constant'
     */
    tmp[i] = 0.0;
    for (i_0 = 0; i_0 < 5; i_0++) {
      tmp[i] += heli_q8_P.K[(i_0 << 1) + i] * rtb_Sum8[i_0];
    }

    /* End of Product: '<S6>/Matrix Multiply' */

    /* Sum: '<S6>/Sum1' incorporates:
     *  Constant: '<S6>/Constant3'
     *  Product: '<S6>/Matrix Multiply1'
     *  SignalConversion generated from: '<S6>/Matrix Multiply1'
     */
    heli_q8_B.Sum1[i] = (heli_q8_P.F[i + 2] * heli_q8_B.Product + heli_q8_P.F[i]
                         * heli_q8_B.Product1) - tmp[i];
  }

  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* Sum: '<Root>/Sum7' incorporates:
     *  Constant: '<Root>/Constant4'
     */
    heli_q8_B.Sum7 = heli_q8_B.ElevationCounttorad + heli_q8_P.e_offset;

    /* Gain: '<S3>/Travel: Count to rad' */
    heli_q8_B.TravelCounttorad = heli_q8_P.TravelCounttorad_Gain *
      rtb_HILReadEncoderTimebase_o1;
  }

  /* TransferFcn: '<S3>/Travel: Transfer Fcn' */
  heli_q8_B.TravelTransferFcn = 0.0;
  heli_q8_B.TravelTransferFcn += heli_q8_P.TravelTransferFcn_C *
    heli_q8_X.TravelTransferFcn_CSTATE;
  heli_q8_B.TravelTransferFcn += heli_q8_P.TravelTransferFcn_D *
    heli_q8_B.TravelCounttorad;
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* Constant: '<Root>/Constant' */
    heli_q8_B.Constant = heli_q8_P.Constant_Value;
  }

  /* Gain: '<S2>/Front gain' incorporates:
   *  Sum: '<S2>/Add'
   */
  rtb_Backgain = (heli_q8_B.Sum1[0] - heli_q8_B.Sum1[1]) *
    heli_q8_P.Frontgain_Gain;

  /* Saturate: '<S3>/Front motor: Saturation' */
  if (rtb_Backgain > heli_q8_P.FrontmotorSaturation_UpperSat) {
    /* Saturate: '<S3>/Front motor: Saturation' */
    heli_q8_B.FrontmotorSaturation = heli_q8_P.FrontmotorSaturation_UpperSat;
  } else if (rtb_Backgain < heli_q8_P.FrontmotorSaturation_LowerSat) {
    /* Saturate: '<S3>/Front motor: Saturation' */
    heli_q8_B.FrontmotorSaturation = heli_q8_P.FrontmotorSaturation_LowerSat;
  } else {
    /* Saturate: '<S3>/Front motor: Saturation' */
    heli_q8_B.FrontmotorSaturation = rtb_Backgain;
  }

  /* End of Saturate: '<S3>/Front motor: Saturation' */

  /* Gain: '<S2>/Back gain' incorporates:
   *  Sum: '<S2>/Subtract'
   */
  rtb_Backgain = (heli_q8_B.Sum1[0] + heli_q8_B.Sum1[1]) *
    heli_q8_P.Backgain_Gain;

  /* Saturate: '<S3>/Back motor: Saturation' */
  if (rtb_Backgain > heli_q8_P.BackmotorSaturation_UpperSat) {
    /* Saturate: '<S3>/Back motor: Saturation' */
    heli_q8_B.BackmotorSaturation = heli_q8_P.BackmotorSaturation_UpperSat;
  } else if (rtb_Backgain < heli_q8_P.BackmotorSaturation_LowerSat) {
    /* Saturate: '<S3>/Back motor: Saturation' */
    heli_q8_B.BackmotorSaturation = heli_q8_P.BackmotorSaturation_LowerSat;
  } else {
    /* Saturate: '<S3>/Back motor: Saturation' */
    heli_q8_B.BackmotorSaturation = rtb_Backgain;
  }

  /* End of Saturate: '<S3>/Back motor: Saturation' */
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* S-Function (hil_write_analog_block): '<S3>/HIL Write Analog' */

    /* S-Function Block: heli_q8/Heli 3D/HIL Write Analog (hil_write_analog_block) */
    {
      t_error result;
      heli_q8_DW.HILWriteAnalog_Buffer[0] = heli_q8_B.FrontmotorSaturation;
      heli_q8_DW.HILWriteAnalog_Buffer[1] = heli_q8_B.BackmotorSaturation;
      result = hil_write_analog(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILWriteAnalog_channels, 2, &heli_q8_DW.HILWriteAnalog_Buffer
        [0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
      }
    }

    for (i = 0; i < 36; i++) {
      /* UnitDelay: '<S5>/Unit Delay1' */
      heli_q8_B.UnitDelay1[i] = heli_q8_DW.UnitDelay1_DSTATE[i];

      /* Product: '<S5>/Product' incorporates:
       *  Constant: '<S5>/omit t mask'
       *  UnitDelay: '<S5>/Unit Delay1'
       */
      heli_q8_B.Product_b[i] = heli_q8_B.UnitDelay1[i] *
        heli_q8_P.omittmask_Value[i];
    }

    /* S-Function (stream_call_block): '<S16>/Stream Call1' incorporates:
     *  Constant: '<S16>/Constant'
     *  S-Function (string_constant_block): '<S16>/String Constant'
     */

    /* S-Function Block: heli_q8/Measurements/IMU/Stream Call1 (stream_call_block) */
    {
      t_error result = 0;
      t_boolean close_flag = (heli_q8_P.Constant_Value_c != 0);
      rtb_StreamCall1_o1 = NULL;
      switch (heli_q8_DW.StreamCall1_State) {
       case STREAM_CALL_STATE_NOT_CONNECTED:
        {
          if (!close_flag) {
            /* Make sure URI is null-terminated */
            if (string_length((char *) heli_q8_P.StringConstant_Value, 255) ==
                255) {
              rtmSetErrorStatus(heli_q8_M,
                                "URI passed to Stream Call block is not null-terminated!");
              result = -QERR_STRING_NOT_TERMINATED;
            } else {
              result = stream_connect((char *) heli_q8_P.StringConstant_Value,
                heli_q8_P.StreamCall1_NonBlocking != 0,
                heli_q8_P.StreamCall1_SendBufferSize,
                heli_q8_P.StreamCall1_ReceiveBufferSize,
                &heli_q8_DW.StreamCall1_Stream);
              if (result == 0) {
                heli_q8_DW.StreamCall1_State = STREAM_CALL_STATE_CONNECTED;
                stream_set_byte_order(heli_q8_DW.StreamCall1_Stream,
                                      (t_stream_byte_order)
                                      heli_q8_P.StreamCall1_Endian);
                rtb_StreamCall1_o1 = &heli_q8_DW.StreamCall1_Stream;
              } else if (result == -QERR_WOULD_BLOCK) {
                heli_q8_DW.StreamCall1_State = STREAM_CALL_STATE_CONNECTING;
                result = 0;
              }
            }
          }
          break;
        }

       case STREAM_CALL_STATE_CONNECTING:
        {
          if (!close_flag) {
            const t_timeout timeout = { 0, 0, false };/* zero seconds */

            result = stream_poll(heli_q8_DW.StreamCall1_Stream, &timeout,
                                 STREAM_POLL_CONNECT);
            if (result > 0) {
              heli_q8_DW.StreamCall1_State = STREAM_CALL_STATE_CONNECTED;
              stream_set_byte_order(heli_q8_DW.StreamCall1_Stream,
                                    (t_stream_byte_order)
                                    heli_q8_P.StreamCall1_Endian);
              rtb_StreamCall1_o1 = &heli_q8_DW.StreamCall1_Stream;
              result = 0;
              break;
            } else if (result == 0) {
              break;
            }
          }

          /* Fall through deliberately */
        }

       case STREAM_CALL_STATE_CONNECTED:
        {
          rtb_StreamCall1_o1 = &heli_q8_DW.StreamCall1_Stream;
          if (!close_flag) {
            break;
          }

          /* Fall through deliberately */
        }

       default:
        {
          t_error close_result = stream_close(heli_q8_DW.StreamCall1_Stream);
          if (close_result == 0) {
            heli_q8_DW.StreamCall1_State = STREAM_CALL_STATE_NOT_CONNECTED;
            heli_q8_DW.StreamCall1_Stream = NULL;
            rtb_StreamCall1_o1 = NULL;
          } else if (result == 0) {
            result = close_result;
          }
          break;
        }
      }

      heli_q8_B.StreamCall1_o2 = heli_q8_DW.StreamCall1_State;
      rtb_StreamCall1_o3 = (int32_T) result;
    }

    /* S-Function (stream_formatted_write_block): '<S16>/Stream Formatted Write' incorporates:
     *  Constant: '<S16>/Constant1'
     */
    {
      t_error result;
      if (rtb_StreamCall1_o1 != NULL) {
        result = stream_print_utf8_char_array(*rtb_StreamCall1_o1,
          heli_q8_P.StreamFormattedWrite_MaxUnits, &rtb_StreamFormattedWrite_o2,
          "%c\n"
          , (char) heli_q8_P.Constant1_Value
          );
        if (result > 0) {
          result = stream_flush(*rtb_StreamCall1_o1);
        }

        if (result == -QERR_WOULD_BLOCK) {
          result = 0;
        }
      }
    }

    /* S-Function (stream_read_block): '<S16>/Stream Read1' incorporates:
     *  Constant: '<S16>/Constant1'
     *  S-Function (stream_call_block): '<S16>/Stream Call1'
     *  S-Function (stream_formatted_write_block): '<S16>/Stream Formatted Write'
     */

    /* S-Function Block: heli_q8/Measurements/IMU/Stream Read1 (stream_read_block) */
    {
      t_error result;
      memset(&rtb_StreamRead1_o2[0], 0, 10 * sizeof(real32_T));
      if (((t_stream_ptr)rtb_StreamCall1_o1) != NULL) {
        result = stream_receive_unit_array(*((t_stream_ptr)rtb_StreamCall1_o1),
          &rtb_StreamRead1_o2[0], sizeof(real32_T), 10);
        heli_q8_B.StreamRead1_o3 = (result > 0);
        if (result > 0 || result == -QERR_WOULD_BLOCK) {
          result = 0;
        }
      } else {
        heli_q8_B.StreamRead1_o3 = false;
        result = 0;
      }
    }

    for (i = 0; i < 10; i++) {
      /* Switch: '<S16>/Switch' */
      if (heli_q8_B.StreamRead1_o3) {
        /* Switch: '<S16>/Switch' incorporates:
         *  DataTypeConversion: '<S16>/Data Type Conversion'
         */
        heli_q8_B.Switch[i] = rtb_StreamRead1_o2[i];
      } else {
        /* Switch: '<S16>/Switch' incorporates:
         *  Memory: '<S16>/Memory'
         */
        heli_q8_B.Switch[i] = heli_q8_DW.Memory_PreviousInput[i];
      }

      /* End of Switch: '<S16>/Switch' */
    }

    /* Gain: '<S16>/Gain2' */
    for (i = 0; i < 3; i++) {
      rtb_Gain2[i] = heli_q8_P.Gain2_Gain[i + 6] * heli_q8_B.Switch[2] +
        (heli_q8_P.Gain2_Gain[i + 3] * heli_q8_B.Switch[1] +
         heli_q8_P.Gain2_Gain[i] * heli_q8_B.Switch[0]);
    }

    /* End of Gain: '<S16>/Gain2' */

    /* MATLAB Function: '<S8>/kre' */
    /* MATLAB Function 'Measurements/kre': '<S17>:1' */
    /* '<S17>:1:3' */
    heli_q8_B.p = -rt_atan2d_snf(rtb_Gain2[1], -rtb_Gain2[2]);

    /* '<S17>:1:4' */
    heli_q8_B.e = rt_atan2d_snf(rtb_Gain2[0], sqrt(rtb_Gain2[1] * rtb_Gain2[1] +
      rtb_Gain2[2] * rtb_Gain2[2]));

    /* Switch: '<S8>/Switch2' incorporates:
     *  Constant: '<S8>/Accl Enable'
     */
    if (heli_q8_P.AcclEnable_Value > heli_q8_P.Switch2_Threshold) {
      /* SignalConversion generated from: '<S15>/ SFunction ' incorporates:
       *  MATLAB Function: '<S8>/Gyro vector to [pitch rate, elevation rate, travle rate]'
       */
      rtb_TmpSignalConversionAtSFun_0 = heli_q8_B.p;
    } else {
      /* SignalConversion generated from: '<S15>/ SFunction ' incorporates:
       *  MATLAB Function: '<S8>/Gyro vector to [pitch rate, elevation rate, travle rate]'
       */
      rtb_TmpSignalConversionAtSFun_0 = heli_q8_B.PitchCounttorad;
    }

    /* End of Switch: '<S8>/Switch2' */

    /* Switch: '<S8>/Switch3' incorporates:
     *  Constant: '<S8>/Accl Enable'
     */
    if (heli_q8_P.AcclEnable_Value > heli_q8_P.Switch3_Threshold) {
      /* SignalConversion generated from: '<S15>/ SFunction ' incorporates:
       *  MATLAB Function: '<S8>/Gyro vector to [pitch rate, elevation rate, travle rate]'
       */
      rtb_TmpSignalConversionAtSFun_1 = heli_q8_B.e;
    } else {
      /* SignalConversion generated from: '<S15>/ SFunction ' incorporates:
       *  MATLAB Function: '<S8>/Gyro vector to [pitch rate, elevation rate, travle rate]'
       */
      rtb_TmpSignalConversionAtSFun_1 = heli_q8_B.Sum7;
    }

    /* End of Switch: '<S8>/Switch3' */

    /* MATLAB Function: '<S8>/Gyro vector to [pitch rate, elevation rate, travle rate]' */
    /* MATLAB Function 'Measurements/Gyro vector to [pitch rate, elevation rate, travle rate]': '<S15>:1' */
    /* '<S15>:1:2' */
    /* '<S15>:1:3' */
    /* '<S15>:1:6' */
    /* '<S15>:1:9' */
    rtb_Backgain = tan(rtb_TmpSignalConversionAtSFun_1);
    euler_rates_tmp = sin(rtb_TmpSignalConversionAtSFun_0);
    rtb_TmpSignalConversionAtSFun_0 = cos(rtb_TmpSignalConversionAtSFun_0);
    rtb_TmpSignalConversionAtSFun_1 = cos(rtb_TmpSignalConversionAtSFun_1);
    tmp_7[0] = 1.0;
    tmp_7[3] = euler_rates_tmp * rtb_Backgain;
    tmp_7[6] = rtb_TmpSignalConversionAtSFun_0 * rtb_Backgain;
    tmp_7[1] = 0.0;
    tmp_7[4] = rtb_TmpSignalConversionAtSFun_0;
    tmp_7[7] = -euler_rates_tmp;
    tmp_7[2] = 0.0;
    tmp_7[5] = euler_rates_tmp / rtb_TmpSignalConversionAtSFun_1;
    tmp_7[8] = rtb_TmpSignalConversionAtSFun_0 / rtb_TmpSignalConversionAtSFun_1;

    /* Gain: '<S16>/Gain1' */
    for (i = 0; i < 3; i++) {
      rtb_Gain2[i] = heli_q8_P.Gain1_Gain[i + 6] * heli_q8_B.Switch[5] +
        (heli_q8_P.Gain1_Gain[i + 3] * heli_q8_B.Switch[4] +
         heli_q8_P.Gain1_Gain[i] * heli_q8_B.Switch[3]);
    }

    /* End of Gain: '<S16>/Gain1' */

    /* MATLAB Function: '<S8>/Gyro vector to [pitch rate, elevation rate, travle rate]' */
    for (i = 0; i < 3; i++) {
      heli_q8_B.euler_rates[i] = 0.0;
      heli_q8_B.euler_rates[i] += tmp_7[i] * rtb_Gain2[0];
      heli_q8_B.euler_rates[i] += tmp_7[i + 3] * rtb_Gain2[1];
      heli_q8_B.euler_rates[i] += tmp_7[i + 6] * rtb_Gain2[2];
    }
  }

  /* MATLAB Function: '<S5>/Kalman prior' incorporates:
   *  Constant: '<S5>/Constant'
   *  Constant: '<S5>/Constant3'
   *  Constant: '<S5>/Constant4'
   *  UnitDelay: '<S5>/Unit Delay1'
   */
  /* MATLAB Function 'Kalman/Kalman prior': '<S14>:1' */
  if (!heli_q8_B.StreamRead1_o3) {
    /* '<S14>:1:2' */
    /* '<S14>:1:3' */
    for (i = 0; i < 6; i++) {
      heli_q8_B.x_bar[i] = heli_q8_B.UnitDelay[i];
    }

    /* '<S14>:1:4' */
    memcpy(&heli_q8_B.P_bar[0], &heli_q8_B.UnitDelay1[0], 36U * sizeof(real_T));
  } else {
    /* '<S14>:1:8' */
    /* '<S14>:1:9' */
    for (i = 0; i < 6; i++) {
      tmp_0[i] = 0.0;
      for (i_0 = 0; i_0 < 6; i_0++) {
        P_bar_tmp = 6 * i_0 + i;
        tmp_1[P_bar_tmp] = 0.0;
        for (L_tmp_tmp = 0; L_tmp_tmp < 6; L_tmp_tmp++) {
          tmp_1[P_bar_tmp] += heli_q8_P.Ad[6 * L_tmp_tmp + i] *
            heli_q8_B.UnitDelay1[6 * i_0 + L_tmp_tmp];
        }

        tmp_0[i] += heli_q8_P.Ad[P_bar_tmp] * heli_q8_B.UnitDelay[i_0];
      }

      heli_q8_B.x_bar[i] = tmp_0[i] + (heli_q8_P.Bd[i + 6] * heli_q8_B.Sum1[1] +
        heli_q8_P.Bd[i] * heli_q8_B.Sum1[0]);
      for (i_0 = 0; i_0 < 6; i_0++) {
        rtb_Backgain = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          rtb_Backgain += tmp_1[6 * P_bar_tmp + i] * heli_q8_P.Ad[6 * P_bar_tmp
            + i_0];
        }

        P_bar_tmp = 6 * i_0 + i;
        heli_q8_B.P_bar[P_bar_tmp] = heli_q8_P.Qd[P_bar_tmp] + rtb_Backgain;
      }
    }
  }

  /* End of MATLAB Function: '<S5>/Kalman prior' */
  if (rtmIsMajorTimeStep(heli_q8_M)) {
  }

  /* MATLAB Function: '<S5>/Kalman posterior' incorporates:
   *  Constant: '<S5>/Constant1'
   *  Constant: '<S5>/Constant2'
   */
  /* MATLAB Function 'Kalman/Kalman posterior': '<S13>:1' */
  if (!heli_q8_B.StreamRead1_o3) {
    /* '<S13>:1:2' */
    /* '<S13>:1:3' */
    for (i = 0; i < 6; i++) {
      heli_q8_B.x_hat_k[i] = heli_q8_B.x_bar[i];
    }

    /* '<S13>:1:4' */
    memcpy(&heli_q8_B.P_hat[0], &heli_q8_B.P_bar[0], 36U * sizeof(real_T));

    /* '<S13>:1:5' */
    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        P_bar_tmp = i + 6 * i_0;
        tmp_1[P_bar_tmp] = 0.0;
        for (L_tmp_tmp = 0; L_tmp_tmp < 6; L_tmp_tmp++) {
          tmp_1[P_bar_tmp] += heli_q8_P.Cd[6 * L_tmp_tmp + i] * heli_q8_B.P_bar
            [6 * i_0 + L_tmp_tmp];
        }
      }

      for (i_0 = 0; i_0 < 6; i_0++) {
        rtb_Backgain = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          rtb_Backgain += tmp_1[6 * P_bar_tmp + i] * heli_q8_P.Cd[6 * P_bar_tmp
            + i_0];
        }

        P_bar_tmp = 6 * i_0 + i;
        P_hat_tmp[P_bar_tmp] = heli_q8_P.Rd[P_bar_tmp] + rtb_Backgain;
      }
    }

    heli_q8_mpower(P_hat_tmp, tmp_1);
    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        P_bar_tmp = i + 6 * i_0;
        P_hat_tmp[P_bar_tmp] = 0.0;
        for (L_tmp_tmp = 0; L_tmp_tmp < 6; L_tmp_tmp++) {
          P_hat_tmp[P_bar_tmp] += heli_q8_B.P_bar[6 * L_tmp_tmp + i] *
            heli_q8_P.Cd[6 * L_tmp_tmp + i_0];
        }
      }

      for (i_0 = 0; i_0 < 6; i_0++) {
        L_tmp_tmp = i + 6 * i_0;
        heli_q8_B.L[L_tmp_tmp] = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          heli_q8_B.L[L_tmp_tmp] += P_hat_tmp[6 * P_bar_tmp + i] * tmp_1[6 * i_0
            + P_bar_tmp];
        }
      }
    }
  } else {
    /* '<S13>:1:9' */
    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        L_tmp_tmp = 6 * i_0 + i;
        L_tmp[i_0 + 6 * i] = heli_q8_P.Cd[L_tmp_tmp];
        tmp_1[L_tmp_tmp] = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          tmp_1[L_tmp_tmp] += heli_q8_P.Cd[6 * P_bar_tmp + i] * heli_q8_B.P_bar
            [6 * i_0 + P_bar_tmp];
        }
      }
    }

    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        rtb_Backgain = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          rtb_Backgain += tmp_1[6 * P_bar_tmp + i] * L_tmp[6 * i_0 + P_bar_tmp];
        }

        P_bar_tmp = 6 * i_0 + i;
        P_hat_tmp[P_bar_tmp] = heli_q8_P.Rd[P_bar_tmp] + rtb_Backgain;
      }
    }

    heli_q8_mpower(P_hat_tmp, tmp_1);

    /* SignalConversion generated from: '<S13>/ SFunction ' incorporates:
     *  Constant: '<S5>/Constant1'
     *  Constant: '<S5>/Constant2'
     */
    /* '<S13>:1:10' */
    tmp_0[0] = heli_q8_B.p;
    tmp_0[1] = heli_q8_B.euler_rates[0];
    tmp_0[2] = heli_q8_B.e;
    tmp_0[3] = heli_q8_B.euler_rates[1];
    tmp_0[4] = heli_q8_B.Constant;
    tmp_0[5] = heli_q8_B.euler_rates[2];
    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        P_bar_tmp = i + 6 * i_0;
        P_hat_tmp[P_bar_tmp] = 0.0;
        for (L_tmp_tmp = 0; L_tmp_tmp < 6; L_tmp_tmp++) {
          P_hat_tmp[P_bar_tmp] += heli_q8_B.P_bar[6 * L_tmp_tmp + i] * L_tmp[6 *
            i_0 + L_tmp_tmp];
        }
      }

      tmp_2[i] = 0.0;
      for (i_0 = 0; i_0 < 6; i_0++) {
        L_tmp_tmp = i + 6 * i_0;
        heli_q8_B.L[L_tmp_tmp] = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          heli_q8_B.L[L_tmp_tmp] += P_hat_tmp[6 * P_bar_tmp + i] * tmp_1[6 * i_0
            + P_bar_tmp];
        }

        tmp_2[i] += heli_q8_P.Cd[L_tmp_tmp] * heli_q8_B.x_bar[i_0];
      }

      tmp_3[i] = tmp_0[i] - tmp_2[i];
    }

    for (i = 0; i < 6; i++) {
      rtb_Backgain = 0.0;
      for (i_0 = 0; i_0 < 6; i_0++) {
        rtb_Backgain += heli_q8_B.L[6 * i_0 + i] * tmp_3[i_0];
      }

      heli_q8_B.x_hat_k[i] = heli_q8_B.x_bar[i] + rtb_Backgain;
    }

    for (i = 0; i < 36; i++) {
      L_tmp[i] = 0.0;
    }

    for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
      L_tmp[P_bar_tmp + 6 * P_bar_tmp] = 1.0;
    }

    /* '<S13>:1:11' */
    for (i = 0; i < 36; i++) {
      b[i] = 0;
    }

    for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
      b[P_bar_tmp + 6 * P_bar_tmp] = 1;
      for (i = 0; i < 6; i++) {
        L_tmp_tmp = P_bar_tmp + 6 * i;
        P_hat_tmp[L_tmp_tmp] = 0.0;
        for (i_0 = 0; i_0 < 6; i_0++) {
          P_hat_tmp[L_tmp_tmp] += heli_q8_B.L[6 * i_0 + P_bar_tmp] *
            heli_q8_P.Cd[6 * i + i_0];
        }
      }
    }

    for (i = 0; i < 36; i++) {
      b_0[i] = (real_T)b[i] - P_hat_tmp[i];
    }

    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        L_tmp_tmp = i + 6 * i_0;
        b_1[L_tmp_tmp] = 0.0;
        L_tmp_0[i_0 + 6 * i] = L_tmp[L_tmp_tmp] - P_hat_tmp[L_tmp_tmp];
        tmp_1[L_tmp_tmp] = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          b_tmp = 6 * P_bar_tmp + i;
          b_tmp_0 = 6 * i_0 + P_bar_tmp;
          b_1[L_tmp_tmp] += b_0[b_tmp] * heli_q8_B.P_bar[b_tmp_0];
          tmp_1[L_tmp_tmp] += heli_q8_B.L[b_tmp] * heli_q8_P.Rd[b_tmp_0];
        }
      }
    }

    for (i = 0; i < 6; i++) {
      for (i_0 = 0; i_0 < 6; i_0++) {
        L_tmp_tmp = i + 6 * i_0;
        b_0[L_tmp_tmp] = 0.0;
        P_hat_tmp[L_tmp_tmp] = 0.0;
        for (P_bar_tmp = 0; P_bar_tmp < 6; P_bar_tmp++) {
          b_tmp = 6 * P_bar_tmp + i;
          b_0[L_tmp_tmp] += b_1[b_tmp] * L_tmp_0[6 * i_0 + P_bar_tmp];
          P_hat_tmp[L_tmp_tmp] += tmp_1[b_tmp] * heli_q8_B.L[6 * P_bar_tmp + i_0];
        }
      }
    }

    for (i = 0; i < 36; i++) {
      heli_q8_B.P_hat[i] = b_0[i] + P_hat_tmp[i];
    }
  }

  /* End of MATLAB Function: '<S5>/Kalman posterior' */
  if (rtmIsMajorTimeStep(heli_q8_M)) {
  }

  /* Sum: '<S6>/Sum2' */
  heli_q8_B.Sum2 = heli_q8_B.Product1 - rtb_Switch4_idx_0;

  /* Sum: '<S6>/Sum4' */
  heli_q8_B.Sum4 = heli_q8_B.Product - rtb_Switch4_idx_2;

  /* Product: '<S7>/MatrixMultiply3' incorporates:
   *  Constant: '<S7>/Constant8'
   */
  for (i = 0; i < 5; i++) {
    rtb_Sum8[i] = 0.0;
    for (i_0 = 0; i_0 < 5; i_0++) {
      rtb_Sum8[i] += heli_q8_P.C_l[5 * i_0 + i] * heli_q8_B.x_hat[i_0];
    }
  }

  /* End of Product: '<S7>/MatrixMultiply3' */

  /* Sum: '<S7>/Sum8' incorporates:
   *  Constant: '<S7>/Constant6'
   *  Product: '<S7>/MatrixMultiply1'
   */
  tmp_4[0] = heli_q8_B.p - rtb_Sum8[0];
  tmp_4[1] = heli_q8_B.euler_rates[0] - rtb_Sum8[1];
  tmp_4[2] = heli_q8_B.e - rtb_Sum8[2];
  tmp_4[3] = heli_q8_B.euler_rates[1] - rtb_Sum8[3];
  tmp_4[4] = heli_q8_B.euler_rates[2] - rtb_Sum8[4];
  for (i = 0; i < 5; i++) {
    rtb_Sum8[i] = tmp_4[i];

    /* Product: '<S7>/MatrixMultiply' incorporates:
     *  Constant: '<S7>/Constant5'
     */
    tmp_5[i] = 0.0;
    for (i_0 = 0; i_0 < 5; i_0++) {
      tmp_5[i] += heli_q8_P.A_l[5 * i_0 + i] * heli_q8_B.x_hat[i_0];
    }

    /* End of Product: '<S7>/MatrixMultiply' */
    tmp_6[i] = heli_q8_P.B_l[i + 5] * heli_q8_B.Sum1[1] + heli_q8_P.B_l[i] *
      heli_q8_B.Sum1[0];
  }

  /* End of Sum: '<S7>/Sum8' */
  for (i = 0; i < 5; i++) {
    /* Sum: '<S7>/Sum9' incorporates:
     *  Constant: '<S7>/Constant7'
     *  Product: '<S7>/MatrixMultiply2'
     */
    rtb_Backgain = 0.0;
    for (i_0 = 0; i_0 < 5; i_0++) {
      rtb_Backgain += heli_q8_P.L_l[5 * i_0 + i] * rtb_Sum8[i_0];
    }

    heli_q8_B.Sum9[i] = (tmp_5[i] + tmp_6[i]) + rtb_Backgain;

    /* End of Sum: '<S7>/Sum9' */
  }

  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* S-Function (stop_with_error_block): '<S16>/Stop with Call Error' */

    /* S-Function Block: heli_q8/Measurements/IMU/Stop with Call Error (stop_with_error_block) */
    {
      if (rtb_StreamCall1_o3 < 0) {
        msg_get_error_messageA(NULL, rtb_StreamCall1_o3, _rt_error_message,
          sizeof(_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }
  }
}

/* Model update function for TID0 */
void heli_q8_update0(void)             /* Sample time: [0.0s, 0.0s] */
{
  int32_T i;
  if (rtmIsMajorTimeStep(heli_q8_M)) {
    /* Update for UnitDelay: '<S5>/Unit Delay' */
    for (i = 0; i < 6; i++) {
      heli_q8_DW.UnitDelay_DSTATE[i] = heli_q8_B.x_hat_k[i];
    }

    /* End of Update for UnitDelay: '<S5>/Unit Delay' */

    /* Update for UnitDelay: '<S5>/Unit Delay1' */
    memcpy(&heli_q8_DW.UnitDelay1_DSTATE[0], &heli_q8_B.P_hat[0], 36U * sizeof
           (real_T));

    /* Update for Memory: '<S16>/Memory' */
    memcpy(&heli_q8_DW.Memory_PreviousInput[0], &heli_q8_B.Switch[0], 10U *
           sizeof(real_T));
  }

  if (rtmIsMajorTimeStep(heli_q8_M)) {
    rt_ertODEUpdateContinuousStates(&heli_q8_M->solverInfo);
  }

  /* Update absolute time */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++heli_q8_M->Timing.clockTick0)) {
    ++heli_q8_M->Timing.clockTickH0;
  }

  heli_q8_M->Timing.t[0] = rtsiGetSolverStopTime(&heli_q8_M->solverInfo);

  /* Update absolute time */
  /* The "clockTick1" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick1"
   * and "Timing.stepSize1". Size of "clockTick1" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick1 and the high bits
   * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++heli_q8_M->Timing.clockTick1)) {
    ++heli_q8_M->Timing.clockTickH1;
  }

  heli_q8_M->Timing.t[1] = heli_q8_M->Timing.clockTick1 *
    heli_q8_M->Timing.stepSize1 + heli_q8_M->Timing.clockTickH1 *
    heli_q8_M->Timing.stepSize1 * 4294967296.0;
}

/* Derivatives for root system: '<Root>' */
void heli_q8_derivatives(void)
{
  XDot_heli_q8_T *_rtXdot;
  int32_T i;
  _rtXdot = ((XDot_heli_q8_T *) heli_q8_M->derivs);

  /* Derivatives for Integrator: '<S7>/Integrator2' */
  for (i = 0; i < 5; i++) {
    _rtXdot->Integrator2_CSTATE[i] = heli_q8_B.Sum9[i];
  }

  /* End of Derivatives for Integrator: '<S7>/Integrator2' */

  /* Derivatives for TransferFcn: '<S3>/Pitch: Transfer Fcn' */
  _rtXdot->PitchTransferFcn_CSTATE = 0.0;
  _rtXdot->PitchTransferFcn_CSTATE += heli_q8_P.PitchTransferFcn_A *
    heli_q8_X.PitchTransferFcn_CSTATE;
  _rtXdot->PitchTransferFcn_CSTATE += heli_q8_B.PitchCounttorad;

  /* Derivatives for TransferFcn: '<S3>/Elevation: Transfer Fcn' */
  _rtXdot->ElevationTransferFcn_CSTATE = 0.0;
  _rtXdot->ElevationTransferFcn_CSTATE += heli_q8_P.ElevationTransferFcn_A *
    heli_q8_X.ElevationTransferFcn_CSTATE;
  _rtXdot->ElevationTransferFcn_CSTATE += heli_q8_B.ElevationCounttorad;

  /* Derivatives for Integrator: '<S6>/Integrator' */
  _rtXdot->Integrator_CSTATE = heli_q8_B.Sum2;

  /* Derivatives for Integrator: '<S6>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = heli_q8_B.Sum4;

  /* Derivatives for TransferFcn: '<S3>/Travel: Transfer Fcn' */
  _rtXdot->TravelTransferFcn_CSTATE = 0.0;
  _rtXdot->TravelTransferFcn_CSTATE += heli_q8_P.TravelTransferFcn_A *
    heli_q8_X.TravelTransferFcn_CSTATE;
  _rtXdot->TravelTransferFcn_CSTATE += heli_q8_B.TravelCounttorad;
}

/* Model output function for TID2 */
void heli_q8_output2(void)             /* Sample time: [0.01s, 0.0s] */
{
  /* local block i/o variables */
  real_T rtb_GameController_o3[2];
  real_T rtb_GameController_o4;
  real_T rtb_GameController_o5;

  /* S-Function (game_controller_block): '<S12>/Game Controller' */

  /* S-Function Block: heli_q8/Input/Joystick/Game Controller (game_controller_block) */
  {
    if (heli_q8_P.GameController_Enabled) {
      t_game_controller_states state;
      t_boolean new_data;
      t_error result;
      result = game_controller_poll(heli_q8_DW.GameController_Controller, &state,
        &new_data);
      if (result < 0) {
        new_data = false;
      }

      rtb_GameController_o3[0] = state.sliders[0];
      rtb_GameController_o3[1] = state.sliders[1];
      rtb_GameController_o4 = state.x;
      rtb_GameController_o5 = state.y;
    } else {
      rtb_GameController_o3[0] = 0;
      rtb_GameController_o3[1] = 0;
      rtb_GameController_o4 = 0;
      rtb_GameController_o5 = 0;
    }
  }

  /* RateTransition: '<S12>/Rate Transition: x' */
  heli_q8_DW.RateTransitionx_Buffer0 = rtb_GameController_o4;

  /* RateTransition: '<S12>/Rate Transition: y' */
  heli_q8_DW.RateTransitiony_Buffer0 = rtb_GameController_o5;

  /* RateTransition: '<S12>/Rate Transition: y1' */
  heli_q8_DW.RateTransitiony1_Buffer0[0] = rtb_GameController_o3[0];
  heli_q8_DW.RateTransitiony1_Buffer0[1] = rtb_GameController_o3[1];
}

/* Model update function for TID2 */
void heli_q8_update2(void)             /* Sample time: [0.01s, 0.0s] */
{
  /* Update absolute time */
  /* The "clockTick2" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick2"
   * and "Timing.stepSize2". Size of "clockTick2" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick2 and the high bits
   * Timing.clockTickH2. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++heli_q8_M->Timing.clockTick2)) {
    ++heli_q8_M->Timing.clockTickH2;
  }

  heli_q8_M->Timing.t[2] = heli_q8_M->Timing.clockTick2 *
    heli_q8_M->Timing.stepSize2 + heli_q8_M->Timing.clockTickH2 *
    heli_q8_M->Timing.stepSize2 * 4294967296.0;
}

/* Model output wrapper function for compatibility with a static main program */
void heli_q8_output(int_T tid)
{
  switch (tid) {
   case 0 :
    heli_q8_output0();
    break;

   case 2 :
    heli_q8_output2();
    break;

   default :
    break;
  }
}

/* Model update wrapper function for compatibility with a static main program */
void heli_q8_update(int_T tid)
{
  switch (tid) {
   case 0 :
    heli_q8_update0();
    break;

   case 2 :
    heli_q8_update2();
    break;

   default :
    break;
  }
}

/* Model initialize function */
void heli_q8_initialize(void)
{
  /* Start for S-Function (hil_initialize_block): '<Root>/HIL Initialize' */

  /* S-Function Block: heli_q8/HIL Initialize (hil_initialize_block) */
  {
    t_int result;
    t_boolean is_switching;
    result = hil_open("q8_usb", "0", &heli_q8_DW.HILInitialize_Card);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(heli_q8_M, _rt_error_message);
      return;
    }

    is_switching = false;
    result = hil_set_card_specific_options(heli_q8_DW.HILInitialize_Card,
      "update_rate=normal;decimation=1", 32);
    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(heli_q8_M, _rt_error_message);
      return;
    }

    result = hil_watchdog_clear(heli_q8_DW.HILInitialize_Card);
    if (result < 0 && result != -QERR_HIL_WATCHDOG_CLEAR) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(heli_q8_M, _rt_error_message);
      return;
    }

    if ((heli_q8_P.HILInitialize_AIPStart && !is_switching) ||
        (heli_q8_P.HILInitialize_AIPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AIMinimums = &heli_q8_DW.HILInitialize_AIMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMinimums[i1] = (heli_q8_P.HILInitialize_AILow);
        }
      }

      {
        int_T i1;
        real_T *dw_AIMaximums = &heli_q8_DW.HILInitialize_AIMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AIMaximums[i1] = heli_q8_P.HILInitialize_AIHigh;
        }
      }

      result = hil_set_analog_input_ranges(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_AIChannels, 8U,
        &heli_q8_DW.HILInitialize_AIMinimums[0],
        &heli_q8_DW.HILInitialize_AIMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if ((heli_q8_P.HILInitialize_AOPStart && !is_switching) ||
        (heli_q8_P.HILInitialize_AOPEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOMinimums = &heli_q8_DW.HILInitialize_AOMinimums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMinimums[i1] = (heli_q8_P.HILInitialize_AOLow);
        }
      }

      {
        int_T i1;
        real_T *dw_AOMaximums = &heli_q8_DW.HILInitialize_AOMaximums[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOMaximums[i1] = heli_q8_P.HILInitialize_AOHigh;
        }
      }

      result = hil_set_analog_output_ranges(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_AOChannels, 8U,
        &heli_q8_DW.HILInitialize_AOMinimums[0],
        &heli_q8_DW.HILInitialize_AOMaximums[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if ((heli_q8_P.HILInitialize_AOStart && !is_switching) ||
        (heli_q8_P.HILInitialize_AOEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &heli_q8_DW.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = heli_q8_P.HILInitialize_AOInitial;
        }
      }

      result = hil_write_analog(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_AOChannels, 8U,
        &heli_q8_DW.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if (heli_q8_P.HILInitialize_AOReset) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &heli_q8_DW.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = heli_q8_P.HILInitialize_AOWatchdog;
        }
      }

      result = hil_watchdog_set_analog_expiration_state
        (heli_q8_DW.HILInitialize_Card, heli_q8_P.HILInitialize_AOChannels, 8U,
         &heli_q8_DW.HILInitialize_AOVoltages[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if ((heli_q8_P.HILInitialize_EIPStart && !is_switching) ||
        (heli_q8_P.HILInitialize_EIPEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_QuadratureModes = &heli_q8_DW.HILInitialize_QuadratureModes
          [0];
        for (i1=0; i1 < 8; i1++) {
          dw_QuadratureModes[i1] = heli_q8_P.HILInitialize_EIQuadrature;
        }
      }

      result = hil_set_encoder_quadrature_mode(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_EIChannels, 8U, (t_encoder_quadrature_mode *)
        &heli_q8_DW.HILInitialize_QuadratureModes[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if ((heli_q8_P.HILInitialize_EIStart && !is_switching) ||
        (heli_q8_P.HILInitialize_EIEnter && is_switching)) {
      {
        int_T i1;
        int32_T *dw_InitialEICounts = &heli_q8_DW.HILInitialize_InitialEICounts
          [0];
        for (i1=0; i1 < 8; i1++) {
          dw_InitialEICounts[i1] = heli_q8_P.HILInitialize_EIInitial;
        }
      }

      result = hil_set_encoder_counts(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_EIChannels, 8U,
        &heli_q8_DW.HILInitialize_InitialEICounts[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if ((heli_q8_P.HILInitialize_POPStart && !is_switching) ||
        (heli_q8_P.HILInitialize_POPEnter && is_switching)) {
      uint32_T num_duty_cycle_modes = 0;
      uint32_T num_frequency_modes = 0;

      {
        int_T i1;
        int32_T *dw_POModeValues = &heli_q8_DW.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = heli_q8_P.HILInitialize_POModes;
        }
      }

      result = hil_set_pwm_mode(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_POChannels, 8U, (t_pwm_mode *)
        &heli_q8_DW.HILInitialize_POModeValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        const uint32_T *p_HILInitialize_POChannels =
          heli_q8_P.HILInitialize_POChannels;
        int32_T *dw_POModeValues = &heli_q8_DW.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          if (dw_POModeValues[i1] == PWM_DUTY_CYCLE_MODE || dw_POModeValues[i1] ==
              PWM_ONE_SHOT_MODE || dw_POModeValues[i1] == PWM_TIME_MODE ||
              dw_POModeValues[i1] == PWM_RAW_MODE) {
            heli_q8_DW.HILInitialize_POSortedChans[num_duty_cycle_modes] =
              (p_HILInitialize_POChannels[i1]);
            heli_q8_DW.HILInitialize_POSortedFreqs[num_duty_cycle_modes] =
              heli_q8_P.HILInitialize_POFrequency;
            num_duty_cycle_modes++;
          } else {
            heli_q8_DW.HILInitialize_POSortedChans[7U - num_frequency_modes] =
              (p_HILInitialize_POChannels[i1]);
            heli_q8_DW.HILInitialize_POSortedFreqs[7U - num_frequency_modes] =
              heli_q8_P.HILInitialize_POFrequency;
            num_frequency_modes++;
          }
        }
      }

      if (num_duty_cycle_modes > 0) {
        result = hil_set_pwm_frequency(heli_q8_DW.HILInitialize_Card,
          &heli_q8_DW.HILInitialize_POSortedChans[0], num_duty_cycle_modes,
          &heli_q8_DW.HILInitialize_POSortedFreqs[0]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(heli_q8_M, _rt_error_message);
          return;
        }
      }

      if (num_frequency_modes > 0) {
        result = hil_set_pwm_duty_cycle(heli_q8_DW.HILInitialize_Card,
          &heli_q8_DW.HILInitialize_POSortedChans[num_duty_cycle_modes],
          num_frequency_modes,
          &heli_q8_DW.HILInitialize_POSortedFreqs[num_duty_cycle_modes]);
        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(heli_q8_M, _rt_error_message);
          return;
        }
      }

      {
        int_T i1;
        int32_T *dw_POModeValues = &heli_q8_DW.HILInitialize_POModeValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POModeValues[i1] = heli_q8_P.HILInitialize_POConfiguration;
        }
      }

      {
        int_T i1;
        int32_T *dw_POAlignValues = &heli_q8_DW.HILInitialize_POAlignValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POAlignValues[i1] = heli_q8_P.HILInitialize_POAlignment;
        }
      }

      {
        int_T i1;
        int32_T *dw_POPolarityVals = &heli_q8_DW.HILInitialize_POPolarityVals[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POPolarityVals[i1] = heli_q8_P.HILInitialize_POPolarity;
        }
      }

      result = hil_set_pwm_configuration(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_POChannels, 8U,
        (t_pwm_configuration *) &heli_q8_DW.HILInitialize_POModeValues[0],
        (t_pwm_alignment *) &heli_q8_DW.HILInitialize_POAlignValues[0],
        (t_pwm_polarity *) &heli_q8_DW.HILInitialize_POPolarityVals[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }

      {
        int_T i1;
        real_T *dw_POSortedFreqs = &heli_q8_DW.HILInitialize_POSortedFreqs[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POSortedFreqs[i1] = heli_q8_P.HILInitialize_POLeading;
        }
      }

      {
        int_T i1;
        real_T *dw_POValues = &heli_q8_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = heli_q8_P.HILInitialize_POTrailing;
        }
      }

      result = hil_set_pwm_deadband(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_POChannels, 8U,
        &heli_q8_DW.HILInitialize_POSortedFreqs[0],
        &heli_q8_DW.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if ((heli_q8_P.HILInitialize_POStart && !is_switching) ||
        (heli_q8_P.HILInitialize_POEnter && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &heli_q8_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = heli_q8_P.HILInitialize_POInitial;
        }
      }

      result = hil_write_pwm(heli_q8_DW.HILInitialize_Card,
        heli_q8_P.HILInitialize_POChannels, 8U,
        &heli_q8_DW.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }

    if (heli_q8_P.HILInitialize_POReset) {
      {
        int_T i1;
        real_T *dw_POValues = &heli_q8_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = heli_q8_P.HILInitialize_POWatchdog;
        }
      }

      result = hil_watchdog_set_pwm_expiration_state
        (heli_q8_DW.HILInitialize_Card, heli_q8_P.HILInitialize_POChannels, 8U,
         &heli_q8_DW.HILInitialize_POValues[0]);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        return;
      }
    }
  }

  /* Start for S-Function (hil_read_encoder_timebase_block): '<S3>/HIL Read Encoder Timebase' */

  /* S-Function Block: heli_q8/Heli 3D/HIL Read Encoder Timebase (hil_read_encoder_timebase_block) */
  {
    t_error result;
    result = hil_task_create_encoder_reader(heli_q8_DW.HILInitialize_Card,
      heli_q8_P.HILReadEncoderTimebase_SamplesI,
      heli_q8_P.HILReadEncoderTimebase_Channels, 3,
      &heli_q8_DW.HILReadEncoderTimebase_Task);
    if (result >= 0) {
      result = hil_task_set_buffer_overflow_mode
        (heli_q8_DW.HILReadEncoderTimebase_Task, (t_buffer_overflow_mode)
         (heli_q8_P.HILReadEncoderTimebase_Overflow - 1));
    }

    if (result < 0) {
      msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
        (_rt_error_message));
      rtmSetErrorStatus(heli_q8_M, _rt_error_message);
    }
  }

  /* Start for RateTransition: '<S12>/Rate Transition: x' */
  heli_q8_B.RateTransitionx = heli_q8_P.RateTransitionx_InitialConditio;

  /* Start for RateTransition: '<S12>/Rate Transition: y1' */
  heli_q8_B.RateTransitiony1[0] = heli_q8_P.RateTransitiony1_InitialConditi;
  heli_q8_B.RateTransitiony1[1] = heli_q8_P.RateTransitiony1_InitialConditi;

  /* Start for RateTransition: '<S12>/Rate Transition: y' */
  heli_q8_B.RateTransitiony = heli_q8_P.RateTransitiony_InitialConditio;

  /* Start for S-Function (stream_call_block): '<S16>/Stream Call1' incorporates:
   *  Constant: '<S16>/Constant'
   *  S-Function (string_constant_block): '<S16>/String Constant'
   */

  /* S-Function Block: heli_q8/Measurements/IMU/Stream Call1 (stream_call_block) */
  {
    heli_q8_DW.StreamCall1_State = STREAM_CALL_STATE_NOT_CONNECTED;
    heli_q8_DW.StreamCall1_Stream = NULL;
  }

  /* Start for S-Function (game_controller_block): '<S12>/Game Controller' */

  /* S-Function Block: heli_q8/Input/Joystick/Game Controller (game_controller_block) */
  {
    if (heli_q8_P.GameController_Enabled) {
      t_double deadzone[6];
      t_double saturation[6];
      t_int index;
      t_error result;
      for (index = 0; index < 6; index++) {
        deadzone[index] = -1;
      }

      for (index = 0; index < 6; index++) {
        saturation[index] = -1;
      }

      result = game_controller_open(heli_q8_P.GameController_ControllerNumber,
        heli_q8_P.GameController_BufferSize, deadzone, saturation,
        heli_q8_P.GameController_AutoCenter, 0, 1.0,
        &heli_q8_DW.GameController_Controller);
      if (result < 0) {
        msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
          (_rt_error_message));
        rtmSetErrorStatus(heli_q8_M, _rt_error_message);
      }
    }
  }

  {
    int32_T i;

    /* InitializeConditions for RateTransition: '<S12>/Rate Transition: x' */
    heli_q8_DW.RateTransitionx_Buffer0 =
      heli_q8_P.RateTransitionx_InitialConditio;

    /* InitializeConditions for RateTransition: '<S12>/Rate Transition: y1' */
    heli_q8_DW.RateTransitiony1_Buffer0[0] =
      heli_q8_P.RateTransitiony1_InitialConditi;
    heli_q8_DW.RateTransitiony1_Buffer0[1] =
      heli_q8_P.RateTransitiony1_InitialConditi;

    /* InitializeConditions for RateTransition: '<S12>/Rate Transition: y' */
    heli_q8_DW.RateTransitiony_Buffer0 =
      heli_q8_P.RateTransitiony_InitialConditio;

    /* InitializeConditions for Integrator: '<S7>/Integrator2' */
    for (i = 0; i < 5; i++) {
      heli_q8_X.Integrator2_CSTATE[i] = heli_q8_P.Integrator2_IC;
    }

    /* End of InitializeConditions for Integrator: '<S7>/Integrator2' */

    /* InitializeConditions for UnitDelay: '<S5>/Unit Delay' */
    for (i = 0; i < 6; i++) {
      heli_q8_DW.UnitDelay_DSTATE[i] = heli_q8_P.x_hat_0[i];
    }

    /* End of InitializeConditions for UnitDelay: '<S5>/Unit Delay' */

    /* InitializeConditions for TransferFcn: '<S3>/Pitch: Transfer Fcn' */
    heli_q8_X.PitchTransferFcn_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S3>/Elevation: Transfer Fcn' */
    heli_q8_X.ElevationTransferFcn_CSTATE = 0.0;

    /* InitializeConditions for Integrator: '<S6>/Integrator' */
    heli_q8_X.Integrator_CSTATE = heli_q8_P.Integrator_IC;

    /* InitializeConditions for Integrator: '<S6>/Integrator1' */
    heli_q8_X.Integrator1_CSTATE = heli_q8_P.Integrator1_IC;

    /* InitializeConditions for TransferFcn: '<S3>/Travel: Transfer Fcn' */
    heli_q8_X.TravelTransferFcn_CSTATE = 0.0;

    /* InitializeConditions for UnitDelay: '<S5>/Unit Delay1' */
    memcpy(&heli_q8_DW.UnitDelay1_DSTATE[0], &heli_q8_P.P_hat_0[0], 36U * sizeof
           (real_T));

    /* InitializeConditions for Memory: '<S16>/Memory' */
    memcpy(&heli_q8_DW.Memory_PreviousInput[0],
           &heli_q8_P.Memory_InitialCondition[0], 10U * sizeof(real_T));
  }
}

/* Model terminate function */
void heli_q8_terminate(void)
{
  /* Terminate for S-Function (hil_initialize_block): '<Root>/HIL Initialize' */

  /* S-Function Block: heli_q8/HIL Initialize (hil_initialize_block) */
  {
    t_boolean is_switching;
    t_int result;
    t_uint32 num_final_analog_outputs = 0;
    t_uint32 num_final_pwm_outputs = 0;
    hil_task_stop_all(heli_q8_DW.HILInitialize_Card);
    hil_monitor_stop_all(heli_q8_DW.HILInitialize_Card);
    is_switching = false;
    if ((heli_q8_P.HILInitialize_AOTerminate && !is_switching) ||
        (heli_q8_P.HILInitialize_AOExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_AOVoltages = &heli_q8_DW.HILInitialize_AOVoltages[0];
        for (i1=0; i1 < 8; i1++) {
          dw_AOVoltages[i1] = heli_q8_P.HILInitialize_AOFinal;
        }
      }

      num_final_analog_outputs = 8U;
    } else {
      num_final_analog_outputs = 0;
    }

    if ((heli_q8_P.HILInitialize_POTerminate && !is_switching) ||
        (heli_q8_P.HILInitialize_POExit && is_switching)) {
      {
        int_T i1;
        real_T *dw_POValues = &heli_q8_DW.HILInitialize_POValues[0];
        for (i1=0; i1 < 8; i1++) {
          dw_POValues[i1] = heli_q8_P.HILInitialize_POFinal;
        }
      }

      num_final_pwm_outputs = 8U;
    } else {
      num_final_pwm_outputs = 0;
    }

    if (0
        || num_final_analog_outputs > 0
        || num_final_pwm_outputs > 0
        ) {
      /* Attempt to write the final outputs atomically (due to firmware issue in old Q2-USB). Otherwise write channels individually */
      result = hil_write(heli_q8_DW.HILInitialize_Card
                         , heli_q8_P.HILInitialize_AOChannels,
                         num_final_analog_outputs
                         , heli_q8_P.HILInitialize_POChannels,
                         num_final_pwm_outputs
                         , NULL, 0
                         , NULL, 0
                         , &heli_q8_DW.HILInitialize_AOVoltages[0]
                         , &heli_q8_DW.HILInitialize_POValues[0]
                         , (t_boolean *) NULL
                         , NULL
                         );
      if (result == -QERR_HIL_WRITE_NOT_SUPPORTED) {
        t_error local_result;
        result = 0;

        /* The hil_write operation is not supported by this card. Write final outputs for each channel type */
        if (num_final_analog_outputs > 0) {
          local_result = hil_write_analog(heli_q8_DW.HILInitialize_Card,
            heli_q8_P.HILInitialize_AOChannels, num_final_analog_outputs,
            &heli_q8_DW.HILInitialize_AOVoltages[0]);
          if (local_result < 0) {
            result = local_result;
          }
        }

        if (num_final_pwm_outputs > 0) {
          local_result = hil_write_pwm(heli_q8_DW.HILInitialize_Card,
            heli_q8_P.HILInitialize_POChannels, num_final_pwm_outputs,
            &heli_q8_DW.HILInitialize_POValues[0]);
          if (local_result < 0) {
            result = local_result;
          }
        }

        if (result < 0) {
          msg_get_error_messageA(NULL, result, _rt_error_message, sizeof
            (_rt_error_message));
          rtmSetErrorStatus(heli_q8_M, _rt_error_message);
        }
      }
    }

    hil_task_delete_all(heli_q8_DW.HILInitialize_Card);
    hil_monitor_delete_all(heli_q8_DW.HILInitialize_Card);
    hil_close(heli_q8_DW.HILInitialize_Card);
    heli_q8_DW.HILInitialize_Card = NULL;
  }

  /* Terminate for S-Function (stream_call_block): '<S16>/Stream Call1' incorporates:
   *  Constant: '<S16>/Constant'
   *  S-Function (string_constant_block): '<S16>/String Constant'
   */

  /* S-Function Block: heli_q8/Measurements/IMU/Stream Call1 (stream_call_block) */
  {
    if (heli_q8_DW.StreamCall1_Stream != NULL) {
      stream_close(heli_q8_DW.StreamCall1_Stream);
      heli_q8_DW.StreamCall1_Stream = NULL;
    }
  }

  /* Terminate for S-Function (game_controller_block): '<S12>/Game Controller' */

  /* S-Function Block: heli_q8/Input/Joystick/Game Controller (game_controller_block) */
  {
    if (heli_q8_P.GameController_Enabled) {
      game_controller_close(heli_q8_DW.GameController_Controller);
      heli_q8_DW.GameController_Controller = NULL;
    }
  }
}

/*========================================================================*
 * Start of Classic call interface                                        *
 *========================================================================*/

/* Solver interface called by GRT_Main */
#ifndef USE_GENERATED_SOLVER

void rt_ODECreateIntegrationData(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

void rt_ODEDestroyIntegrationData(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

void rt_ODEUpdateContinuousStates(RTWSolverInfo *si)
{
  UNUSED_PARAMETER(si);
  return;
}                                      /* do nothing */

#endif

void MdlOutputs(int_T tid)
{
  if (tid == 1)
    tid = 0;
  heli_q8_output(tid);
}

void MdlUpdate(int_T tid)
{
  if (tid == 1)
    tid = 0;
  heli_q8_update(tid);
}

void MdlInitializeSizes(void)
{
}

void MdlInitializeSampleTimes(void)
{
}

void MdlInitialize(void)
{
}

void MdlStart(void)
{
  heli_q8_initialize();
}

void MdlTerminate(void)
{
  heli_q8_terminate();
}

/* Registration function */
RT_MODEL_heli_q8_T *heli_q8(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  /* initialize real-time model */
  (void) memset((void *)heli_q8_M, 0,
                sizeof(RT_MODEL_heli_q8_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&heli_q8_M->solverInfo, &heli_q8_M->Timing.simTimeStep);
    rtsiSetTPtr(&heli_q8_M->solverInfo, &rtmGetTPtr(heli_q8_M));
    rtsiSetStepSizePtr(&heli_q8_M->solverInfo, &heli_q8_M->Timing.stepSize0);
    rtsiSetdXPtr(&heli_q8_M->solverInfo, &heli_q8_M->derivs);
    rtsiSetContStatesPtr(&heli_q8_M->solverInfo, (real_T **)
                         &heli_q8_M->contStates);
    rtsiSetNumContStatesPtr(&heli_q8_M->solverInfo,
      &heli_q8_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&heli_q8_M->solverInfo,
      &heli_q8_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&heli_q8_M->solverInfo,
      &heli_q8_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&heli_q8_M->solverInfo,
      &heli_q8_M->periodicContStateRanges);
    rtsiSetErrorStatusPtr(&heli_q8_M->solverInfo, (&rtmGetErrorStatus(heli_q8_M)));
    rtsiSetRTModelPtr(&heli_q8_M->solverInfo, heli_q8_M);
  }

  rtsiSetSimTimeStep(&heli_q8_M->solverInfo, MAJOR_TIME_STEP);
  heli_q8_M->intgData.f[0] = heli_q8_M->odeF[0];
  heli_q8_M->contStates = ((real_T *) &heli_q8_X);
  rtsiSetSolverData(&heli_q8_M->solverInfo, (void *)&heli_q8_M->intgData);
  rtsiSetSolverName(&heli_q8_M->solverInfo,"ode1");

  /* Initialize timing info */
  {
    int_T *mdlTsMap = heli_q8_M->Timing.sampleTimeTaskIDArray;
    mdlTsMap[0] = 0;
    mdlTsMap[1] = 1;
    mdlTsMap[2] = 2;
    heli_q8_M->Timing.sampleTimeTaskIDPtr = (&mdlTsMap[0]);
    heli_q8_M->Timing.sampleTimes = (&heli_q8_M->Timing.sampleTimesArray[0]);
    heli_q8_M->Timing.offsetTimes = (&heli_q8_M->Timing.offsetTimesArray[0]);

    /* task periods */
    heli_q8_M->Timing.sampleTimes[0] = (0.0);
    heli_q8_M->Timing.sampleTimes[1] = (0.002);
    heli_q8_M->Timing.sampleTimes[2] = (0.01);

    /* task offsets */
    heli_q8_M->Timing.offsetTimes[0] = (0.0);
    heli_q8_M->Timing.offsetTimes[1] = (0.0);
    heli_q8_M->Timing.offsetTimes[2] = (0.0);
  }

  rtmSetTPtr(heli_q8_M, &heli_q8_M->Timing.tArray[0]);

  {
    int_T *mdlSampleHits = heli_q8_M->Timing.sampleHitArray;
    int_T *mdlPerTaskSampleHits = heli_q8_M->Timing.perTaskSampleHitsArray;
    heli_q8_M->Timing.perTaskSampleHits = (&mdlPerTaskSampleHits[0]);
    mdlSampleHits[0] = 1;
    heli_q8_M->Timing.sampleHits = (&mdlSampleHits[0]);
  }

  rtmSetTFinal(heli_q8_M, -1);
  heli_q8_M->Timing.stepSize0 = 0.002;
  heli_q8_M->Timing.stepSize1 = 0.002;
  heli_q8_M->Timing.stepSize2 = 0.01;

  /* External mode info */
  heli_q8_M->Sizes.checksums[0] = (852316735U);
  heli_q8_M->Sizes.checksums[1] = (548676934U);
  heli_q8_M->Sizes.checksums[2] = (864078353U);
  heli_q8_M->Sizes.checksums[3] = (1862987906U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[8];
    heli_q8_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = &rtAlwaysEnabled;
    systemRan[4] = &rtAlwaysEnabled;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(heli_q8_M->extModeInfo,
      &heli_q8_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(heli_q8_M->extModeInfo, heli_q8_M->Sizes.checksums);
    rteiSetTPtr(heli_q8_M->extModeInfo, rtmGetTPtr(heli_q8_M));
  }

  heli_q8_M->solverInfoPtr = (&heli_q8_M->solverInfo);
  heli_q8_M->Timing.stepSize = (0.002);
  rtsiSetFixedStepSize(&heli_q8_M->solverInfo, 0.002);
  rtsiSetSolverMode(&heli_q8_M->solverInfo, SOLVER_MODE_MULTITASKING);

  /* block I/O */
  heli_q8_M->blockIO = ((void *) &heli_q8_B);
  (void) memset(((void *) &heli_q8_B), 0,
                sizeof(B_heli_q8_T));

  {
    int32_T i;
    for (i = 0; i < 5; i++) {
      heli_q8_B.x_hat[i] = 0.0;
    }

    for (i = 0; i < 6; i++) {
      heli_q8_B.UnitDelay[i] = 0.0;
    }

    for (i = 0; i < 5; i++) {
      heli_q8_B.Switch5[i] = 0.0;
    }

    for (i = 0; i < 36; i++) {
      heli_q8_B.UnitDelay1[i] = 0.0;
    }

    for (i = 0; i < 36; i++) {
      heli_q8_B.Product_b[i] = 0.0;
    }

    for (i = 0; i < 10; i++) {
      heli_q8_B.Switch[i] = 0.0;
    }

    for (i = 0; i < 5; i++) {
      heli_q8_B.Sum9[i] = 0.0;
    }

    for (i = 0; i < 6; i++) {
      heli_q8_B.x_bar[i] = 0.0;
    }

    for (i = 0; i < 36; i++) {
      heli_q8_B.P_bar[i] = 0.0;
    }

    for (i = 0; i < 6; i++) {
      heli_q8_B.x_hat_k[i] = 0.0;
    }

    for (i = 0; i < 36; i++) {
      heli_q8_B.P_hat[i] = 0.0;
    }

    for (i = 0; i < 36; i++) {
      heli_q8_B.L[i] = 0.0;
    }

    heli_q8_B.RateTransitionx = 0.0;
    heli_q8_B.Joystick_gain_x = 0.0;
    heli_q8_B.RateTransitiony1[0] = 0.0;
    heli_q8_B.RateTransitiony1[1] = 0.0;
    heli_q8_B.Product1 = 0.0;
    heli_q8_B.RateTransitiony = 0.0;
    heli_q8_B.Joystick_gain_y = 0.0;
    heli_q8_B.Product = 0.0;
    heli_q8_B.PitchCounttorad = 0.0;
    heli_q8_B.PitchTransferFcn = 0.0;
    heli_q8_B.ElevationCounttorad = 0.0;
    heli_q8_B.ElevationTransferFcn = 0.0;
    heli_q8_B.Sum1[0] = 0.0;
    heli_q8_B.Sum1[1] = 0.0;
    heli_q8_B.Sum7 = 0.0;
    heli_q8_B.TravelCounttorad = 0.0;
    heli_q8_B.TravelTransferFcn = 0.0;
    heli_q8_B.Constant = 0.0;
    heli_q8_B.FrontmotorSaturation = 0.0;
    heli_q8_B.BackmotorSaturation = 0.0;
    heli_q8_B.Sum2 = 0.0;
    heli_q8_B.Sum4 = 0.0;
    heli_q8_B.p = 0.0;
    heli_q8_B.e = 0.0;
    heli_q8_B.euler_rates[0] = 0.0;
    heli_q8_B.euler_rates[1] = 0.0;
    heli_q8_B.euler_rates[2] = 0.0;
  }

  /* parameters */
  heli_q8_M->defaultParam = ((real_T *)&heli_q8_P);

  /* states (continuous) */
  {
    real_T *x = (real_T *) &heli_q8_X;
    heli_q8_M->contStates = (x);
    (void) memset((void *)&heli_q8_X, 0,
                  sizeof(X_heli_q8_T));
  }

  /* states (dwork) */
  heli_q8_M->dwork = ((void *) &heli_q8_DW);
  (void) memset((void *)&heli_q8_DW, 0,
                sizeof(DW_heli_q8_T));

  {
    int32_T i;
    for (i = 0; i < 6; i++) {
      heli_q8_DW.UnitDelay_DSTATE[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 36; i++) {
      heli_q8_DW.UnitDelay1_DSTATE[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_AIMinimums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_AIMaximums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_AOMinimums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_AOMaximums[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_AOVoltages[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_FilterFrequency[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_POSortedFreqs[i] = 0.0;
    }
  }

  {
    int32_T i;
    for (i = 0; i < 8; i++) {
      heli_q8_DW.HILInitialize_POValues[i] = 0.0;
    }
  }

  heli_q8_DW.RateTransitionx_Buffer0 = 0.0;
  heli_q8_DW.RateTransitiony1_Buffer0[0] = 0.0;
  heli_q8_DW.RateTransitiony1_Buffer0[1] = 0.0;
  heli_q8_DW.RateTransitiony_Buffer0 = 0.0;
  heli_q8_DW.HILWriteAnalog_Buffer[0] = 0.0;
  heli_q8_DW.HILWriteAnalog_Buffer[1] = 0.0;

  {
    int32_T i;
    for (i = 0; i < 10; i++) {
      heli_q8_DW.Memory_PreviousInput[i] = 0.0;
    }
  }

  /* data type transition information */
  {
    static DataTypeTransInfo dtInfo;
    (void) memset((char_T *) &dtInfo, 0,
                  sizeof(dtInfo));
    heli_q8_M->SpecialInfo.mappingInfo = (&dtInfo);
    dtInfo.numDataTypes = 25;
    dtInfo.dataTypeSizes = &rtDataTypeSizes[0];
    dtInfo.dataTypeNames = &rtDataTypeNames[0];

    /* Block I/O transition table */
    dtInfo.BTransTable = &rtBTransTable;

    /* Parameters transition table */
    dtInfo.PTransTable = &rtPTransTable;
  }

  /* Initialize Sizes */
  heli_q8_M->Sizes.numContStates = (10);/* Number of continuous states */
  heli_q8_M->Sizes.numPeriodicContStates = (0);
                                      /* Number of periodic continuous states */
  heli_q8_M->Sizes.numY = (0);         /* Number of model outputs */
  heli_q8_M->Sizes.numU = (0);         /* Number of model inputs */
  heli_q8_M->Sizes.sysDirFeedThru = (0);/* The model is not direct feedthrough */
  heli_q8_M->Sizes.numSampTimes = (3); /* Number of sample times */
  heli_q8_M->Sizes.numBlocks = (167);  /* Number of blocks */
  heli_q8_M->Sizes.numBlockIO = (37);  /* Number of block outputs */
  heli_q8_M->Sizes.numBlockPrms = (791);/* Sum of parameter "widths" */
  return heli_q8_M;
}

/*========================================================================*
 * End of Classic call interface                                          *
 *========================================================================*/
